package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.*;
import com.yeejoin.amos.api.tool.face.orm.dao.DataBaseLinkMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.DataBaseLink;
import com.yeejoin.amos.api.tool.utils.AESUtils;
import com.yeejoin.amos.api.tool.utils.DataBaseUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import javax.sql.DataSource;
import java.io.IOException;
import java.net.URL;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author r
 */

@Service
public class DataBaseLinkService extends BaseService<DataBaseLinkModel, DataBaseLink, DataBaseLinkMapper> {

    private static final Logger log = LogManager.getLogger(DataBaseLinkService.class);

    @Autowired
    private DataSource dataSource;

    /**
     * 新增
     */
    public DataBaseLinkModel save(DataBaseLinkModel dataBaseLinkModel) throws Exception {
        DataBaseLinkModel model = this.encryptPwd(dataBaseLinkModel);
        if (this.testConnection(model)) {
            return this.createWithModel(model);
        } else {
            return new DataBaseLinkModel();
        }
    }

    /**
     * 编辑
     */

    public DataBaseLinkModel update(DataBaseLinkModel model) throws Exception {
//        DataBaseLinkModel model = this.decryptPwd(dataBaseLinkModel);
        if (this.testConnection(model)) {
            return this.updateWithModel(encryptPwd(model));
        } else {
            return null;
        }
    }

    /**
     * 机构分页查询
     */
    public Page<AgencyModel> queryForAgencyPage(Page<AgencyModel> page, Long ipSeq) throws SQLException {
        Connection connection = this.connectNewDatabase(this.queryBySeq(ipSeq));
        List<Map<String, Object>> maps =
                DataBaseUtils.getMaps("SELECT AGENCY_NAME, AGENCY_CODE, AGENCY_DESC FROM privilege_agency;", connection);
        connection.close();
        List<AgencyModel> records = new ArrayList<>();
        for (Map<String, Object> map : maps) {
            AgencyModel model = new AgencyModel();
            model.setAgencyName(map.get("AGENCY_NAME").toString());
            model.setAgencyCode(map.get("AGENCY_CODE").toString());
            if ((map.get("AGENCY_DESC") != null))
                model.setAgencyDesc(map.get("AGENCY_DESC").toString());
            records.add(model);
        }
        Page<AgencyModel> entiryPage = new Page(page.getCurrent(), page.getSize());
        if (!ValidationUtil.isEmpty(records)) {
            page.setTotal(records.size());
            page.setPages(entiryPage.getPages());
            page.setCurrent(entiryPage.getCurrent());
            page.setSize(entiryPage.getSize());
            page.setRecords(records);
        }
        return page;
    }

    /**
     * 机构列表查询
     */
    public List<AgencyModel> queryForAgencyList() throws SQLException, IOException {
        Connection con = dataSource.getConnection();
        URL url = new URL
                (con.getMetaData().getURL().replace("jdbc:mysql", "http"));
        con.close();
        log.info(url);
        DataBaseLink dataBaseLink = getOne(new QueryWrapper<DataBaseLink>().eq("IP", url.getHost()));
        DataBaseLinkModel dataBaseLinkModel = new DataBaseLinkModel();
        Bean.toModel(dataBaseLink, dataBaseLinkModel);
        Connection connection = this.connectNewDatabase(dataBaseLinkModel);
        List<Map<String, Object>> maps = DataBaseUtils.getMaps
                ("SELECT AGENCY_NAME, AGENCY_CODE, AGENCY_DESC FROM privilege_agency;", connection);
        connection.close();
        List<AgencyModel> records = new ArrayList<>();
        for (Map<String, Object> map : maps) {
            AgencyModel model = new AgencyModel();
            model.setAgencyName(map.get("AGENCY_NAME").toString());
            model.setAgencyCode(map.get("AGENCY_CODE").toString());
            if ((map.get("AGENCY_DESC") != null))
                model.setAgencyDesc(map.get("AGENCY_DESC").toString());
            records.add(model);
        }
        return records;
    }


    /**
     * 列表查询
     */
    public List<DataBaseLinkModel> queryForDataBaseList() {
        return this.queryForList("", false);
    }

    /**
     * 获取数据库名称
     */
    public String[] getDataBaseName(Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW DATABASES");
        String[] result = new String[1000];
        int count = 0;
        while (rs.next()) {
            result[count++] = rs.getString(1);
        }
        return result;
    }

    /**
     * 连接数据库
     */
    public Connection connectNewDatabase(DataBaseLinkModel model) {
        try {
            // 加载数据库驱动
            Class.forName("com.mysql.cj.jdbc.Driver");
            if (model.getPrefix() == null || model.getPrefix().isEmpty() || model.getPrefix().equals("null")) {
                model.setPrefix("");
            }
            if (model.getSuffix() == null || model.getSuffix().isEmpty() || model.getSuffix().equals("null")) {
                model.setSuffix("");
            }
            // 连接新增的数据库
//            String dbUrl = "jdbc:mysql://" + model.getIp() + ":" + model.getPort() + "/" +
//                    model.getPrefix() + model.getDbName() + model.getSuffix();
            String dbUrl = "jdbc:mysql://" + model.getIp() + ":" + model.getPort() + "/" + model.getDbName() ;
            // 解密pwd，并连接
            return DriverManager.getConnection(dbUrl, model.getUserName(), AESUtils.decrypt(model.getPassWord()));
        } catch (SQLException | ClassNotFoundException e) {
            e.printStackTrace();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /**
     * 测试连接数据库
     */
    public boolean testConnection(DataBaseLinkModel model) throws Exception {
        Connection connection = this.connectNewDatabase(model);
        if (connection != null) {
            connection.close();
            return true;
        }
        return false;
    }


    /**
     * 加密model里的密码
     */
    public DataBaseLinkModel encryptPwd(DataBaseLinkModel model) throws Exception {
        model.setPassWord(AESUtils.encrypt(model.getPassWord()));
        return model;
    }

    public DataBaseLinkModel decryptPwd(DataBaseLinkModel model) throws Exception {
        model.setPassWord(AESUtils.decrypt(model.getPassWord()));
        return model;
    }


}
