package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.DataBaseLinkModel;
import com.yeejoin.amos.api.tool.face.model.DataBaseNameListModel;
import com.yeejoin.amos.api.tool.face.orm.dao.DataBaseNameListMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.DataBaseNameList;
import com.yeejoin.amos.api.tool.utils.DataBaseUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.sql.*;
import java.util.*;

@Service
public class DataBaseNameListService extends BaseService<DataBaseNameListModel, DataBaseNameList, DataBaseNameListMapper> {
    @Autowired
    private DataBaseLinkService dataBaseLinkService;

    @Autowired
    private DataBaseNameListMapper dataBaseNameListMapper;

    /**
     * 分页查询
     */
    public Page<DataBaseNameListModel> queryForDataBasePage(Page<DataBaseNameListModel> page,Long parentId,int current,int size) throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.cj.jdbc.Driver");
        DataBaseLinkModel dataBaseLinkModel = dataBaseLinkService.queryBySeq(parentId);
        String ip=dataBaseLinkModel.getIp();
        String port=dataBaseLinkModel.getPort();
        String url = "jdbc:mysql://"+ip+":"+port+" ";
        String user = "root";
        String passWord = "Yeejoin@2020";
        String sql="show databases";
        Connection connection = DriverManager.getConnection(url,user,passWord);
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(sql);
        List<DataBaseNameListModel> list=new ArrayList<>();
        long result=1;
        try {
              while (rs.next()){
                  DataBaseNameListModel listModel=new DataBaseNameListModel();
                  listModel.setDbName(rs.getString("Database"));
                  listModel.setParentId(parentId);
                  listModel.setSequenceNbr(result);
                  list.add(listModel);
                  result++;
              }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            try {
                if (rs != null)
                    rs.close();
                rs = null;
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        connection.close();
//        List<DataBaseNameList> dataBaseNameLists = dataBaseNameListMapper.queryList();
//        for (DataBaseNameList dataBaseNameList:dataBaseNameLists){
//            for (DataBaseNameListModel dataBaseNameListModel:list){
//                if (dataBaseNameList.getDbName().equals(dataBaseNameListModel.getDbName())){
//                    dataBaseLinkModel.setSequenceNbr(dataBaseNameList.getSequenceNbr());
//                }
//            }
//        }
        int count = list.size();
        page.setSize(size);
        page.setCurrent(current);
        page.setTotal(count);
         //计算分页总页数
        page.setPages(count %10 == 0 ? count/10 :count/10+1);
        int startIndex = (current - 1) * size;
        page.setRecords(list.subList(startIndex, Math.min(startIndex + size, list.size())));
        return page;
    }

    /**
     * 初始化数据库名表
     */
    public List<String> refreshDataBase(Long ipSeq) throws Exception {
        DataBaseLinkModel dataBaseLinkModel = dataBaseLinkService.queryBySeq(ipSeq);
        //清空表单
        this.remove(new QueryWrapper<DataBaseNameList>().eq("PARENT_ID", ipSeq));
        //连接数据库
        Connection connection = dataBaseLinkService.connectNewDatabase(dataBaseLinkModel);
        if (connection == null)
            return null;
        List<String> strings = new ArrayList<>();
        Collection<DataBaseNameList> dataBaseNameLists = new ArrayList<>();
        for (String name : dataBaseLinkService.getDataBaseName(connection)) {
            if (name == null)
                break;
            DataBaseNameListModel model = new DataBaseNameListModel(name, ipSeq);
            strings.add(name);
            dataBaseNameLists.add(this.prepareEntity(model));
        }
        this.saveBatch(dataBaseNameLists);
        connection.close();
        return strings;
    }
}
