package com.yeejoin.amos.api.tool.face.service;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.tool.enums.SourceEnum;
import com.yeejoin.amos.api.tool.face.model.DataBaseLinkModel;
import com.yeejoin.amos.api.tool.face.model.DataBaseNameListModel;
import com.yeejoin.amos.api.tool.face.model.RelationModel;
import com.yeejoin.amos.api.tool.face.model.RelationTreeModel;
import com.yeejoin.amos.api.tool.face.orm.dao.RelationMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.Relation;
import com.yeejoin.amos.api.tool.face.orm.entity.TableColumn;
import com.yeejoin.amos.api.tool.utils.DataBaseUtils;
import com.yeejoin.amos.api.tool.utils.DateUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.sql.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.yeejoin.amos.api.tool.utils.DataBaseUtils.*;

@Service
public class RelationService extends BaseService<RelationModel, Relation, RelationMapper> {


    @Autowired
    private RelationMapper relationMapper;
    @Autowired
    private DataBaseLinkService dataBaseLinkService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    private DataBaseNameListService dataBaseNameListService;
    @Autowired
    public EmqKeeper emqKeeper;
    /**
     * 根据机构删除
     */
    public void deleteAgency(String agencyCode, String sequenceNbrs) throws Exception {
        for (Long seq : (Long[]) ConvertUtils.convert(StringUtil.string2Array(sequenceNbrs), Long.class)) {
            DataBaseNameListModel nameListModel = dataBaseNameListService.queryBySeq(seq);
            DataBaseLinkModel model = dataBaseLinkService.queryBySeq(nameListModel.getParentId());
            model.setDbName(nameListModel.getDbName());
            Connection connection = dataBaseLinkService.connectNewDatabase(model);
            this.deleteDataBase(
                    connection, agencyCode, model.getDbName());
        }
    }

    /**
     * 导出机构
     */
    public void outputAgency(String agencyCode,Long ipSeq, String dbName, HttpServletResponse response) throws Exception {
//        for (Long seq : (Long[]) ConvertUtils.convert(StringUtil.string2Array(sequenceNbrs), Long.class)) {
//          DataBaseNameListModel nameListModel = dataBaseNameListService.queryBySeq(seq);
            DataBaseLinkModel model = dataBaseLinkService.queryBySeq(ipSeq);
            Connection connection = dataBaseLinkService.connectNewDatabase(model);
            model.setDbName(dbName);
            this.insertData(connection, agencyCode, model.getDbName(), ipSeq, response);
//        }
    }

    /**
     * 删除数据库
     */
    public String deleteDataBase(Connection connection, String agencyCode, String dbName) throws SQLException {
        try {
            if (!connection.isClosed())
                System.out.println("Succeeded connecting to the Database!");
            //通过连接获取relation表树形结构
            List<RelationTreeModel> trees = this.createRelationTree(dbName);
            for (RelationTreeModel tree : trees) {
                //根据根节点获得根节点相关列表
                List<RelationTreeModel> array = this.createList(tree);
                //根据列表获取sql语句
                System.out.println(this.createSqlByArray(array, agencyCode));
                System.out.println(statementSql(this.createSqlByArray(array, agencyCode).toString(), connection));
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }
        connection.close();
        return null;
    }

    /**
     * 执行sql
     */
    public int statementSql(String sql, Connection connection) {
        int count = 0;
        try {
            Statement statement = connection.createStatement();
            count = statement.executeUpdate(sql);
            statement.close();
            return count;
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    /**
     * 获取关系表转化为map
     */
    public List<HashMap<String, String>> queryRelation(String dbName) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT RESOURCE_INSERT_SQL FROM studio_resource where RESOURCE_CODE = 'Agency'");
//        sql.append(dbName).append("_relation;");RESOURCE_PARAMS,
        return relationMapper.getPublicItems(sql.toString());
    }

    /**
     * 递归建立树形结构 （算法）
     */
    public List<RelationTreeModel> createTree(List<RelationTreeModel> relationTreeModels, String parentName) {
        List<RelationTreeModel> tree = new ArrayList<>();
        for (RelationTreeModel relationTreeModel : relationTreeModels) {
            if (relationTreeModel == null) continue;

            if (parentName.equals(relationTreeModel.getParentName())) {
                relationTreeModel.setChildren(createTree(relationTreeModels, relationTreeModel.getName()));
                tree.add(relationTreeModel);
            }
        }
        return tree;
    }

    /**
     * 创建节点列表
     */
    public List<RelationTreeModel> createNodes(List<HashMap<String, String>> maps) {
        List<RelationTreeModel> relationTreeModels = new ArrayList<>();
        for (HashMap<String, String> map : maps) {
            RelationTreeModel model = new RelationTreeModel(
                    map.get("TABLE2"), map.get("TABLE2_FIELD"), map.get("TABLE1_FIELD"));
            if (map.get("TABLE1") == null)
                model.setParentName("");
            else
                model.setParentName(map.get("TABLE1"));
            relationTreeModels.add(model);
        }
        return relationTreeModels;
    }

    /**
     * 创建关系表树
     */
    public List<RelationTreeModel> createRelationTree(String dbName) throws SQLException {
        List<HashMap<String, String>> maps = this.queryRelation(dbName);
        List<RelationTreeModel> trees = new ArrayList<>();
        trees.addAll(createTree(createNodes(maps), ""));
        return trees;
    }

    /**
     * 根据列表生成sql语句
     */
    public StringBuilder createSqlByArray(List<RelationTreeModel> array, String agencyCode) {
        StringBuilder sql = new StringBuilder();
        if (array.size() == 1) {
            sql.append("DELETE FROM ").append(array.get(0).getName()).append(" WHERE ");
            sql.append(array.get(0).getName()).append(".").append(array.get(0).getField());
            sql.append(" = '").append(agencyCode).append("' ;");
        } else {
            sql.append("DELETE ").append(array.get(0).getName());
            for (RelationTreeModel model : array) {
                if (!model.getParentName().equals(""))
                    sql.append(", ").append(model.getName());
            }
            sql.append(" FROM ").append(array.get(0).getName());
            for (RelationTreeModel model : array) {
                if (!model.getParentName().equals("")) {
                    sql.append(" LEFT JOIN ").append(model.getName()).append(" ON ");
                    sql.append(model.getParentName()).append(".").append(model.getParentField()).append(" = ");
                    sql.append(model.getName()).append(".").append(model.getField());
                }
            }
            sql.append(" WHERE ").append(array.get(0).getName()).append(".").append(array.get(0).getField());
            sql.append(" = '").append(agencyCode).append("' ;");
        }
        return sql;
    }

    /**
     * 插入数据
     */
    public void insertData(Connection connection, String agencyCode, String dbName,Long seq,HttpServletResponse response) throws SQLException {
        try {
            File directory = new File("");// 参数为空
            String coursePath = directory.getCanonicalPath();
            File parentFile = new File(coursePath).getParentFile();
            String backPath = parentFile.getCanonicalPath() + BACKUP_PATH;
            File sqlDirectory = new File(backPath);
            if (!sqlDirectory.exists()) {
                sqlDirectory.mkdir();
            }

            print(seq.toString(),"开始执行", "start");

            String fileName = "studio_" + DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
            String sqlFilePath = backPath + SLASH + fileName;
            File file = new File(sqlFilePath);

            FileOutputStream out;
            OutputStreamWriter writer = null;

            out = new FileOutputStream(file);
            writer = new OutputStreamWriter(out, "utf8");

            StringBuffer insertSql = new StringBuffer();

            //通过连接获取relation表树形结构
            List<RelationTreeModel> trees = this.createRelationTree(dbName);
            for (RelationTreeModel tree : trees) {
                //根据根节点获得根节点相关列表
                List<RelationTreeModel> array = this.createList(tree);
                //根据列表获取sql语句
                for (RelationTreeModel model : array) {
                    List<RelationTreeModel> tableSet = tableRelation(model, array);
                    List<TableColumn> columns = DataBaseUtils.getTableColumn(model.getName(), connection);
                    String selectSQL = this.getSelectSQL(tableSet, model.getName(), columns, agencyCode).toString();
                    print(seq.toString(),"开始查询"+model.getName()+"表","running");
                    List<Map<String, Object>> dataList = DataBaseUtils.getMaps(selectSQL, connection);
                    print(seq.toString(),"开始创建"+model.getName()+"表insert语句","running");
                    System.out.println(selectSQL);
                    StringBuffer insertSQL = DataBaseUtils.getInsertSQL(dataList, columns, model.getName());
                    System.out.println(insertSQL);
                    if (!ObjectUtils.isEmpty(insertSQL))  insertSql.append(insertSQL);
                }
            }
            if (insertSql.length() > 0) {
                writer.write(BR + DELIMITER + BR);
                writer.write("/**" + BR + "* 资源数据" + BR + "**/" + BR);
                writer.write(BR + DELIMITER + BR);
                writer.write(insertSql.toString());
                writer.write(BR + BR + DELIMITER + BR);
                print(seq.toString(), "insert语句创建完成...", "running");
            }
            writer.flush();
            writer.close();
            out.close();
            connection.close();

            if (insertSql.length() == 0) {
                print(seq.toString(), "该项目下数据路径字段为空，不支持导出...", "start");
                return;
            }
           download(response, fileName, sqlFilePath);
            print(seq.toString(),"执行结束", "end");
        } catch (SQLException | IOException e) {
            e.printStackTrace();
        }
    }

    public  void print(String id, String msg, String step) {
        String percent = "0";
        percent = ValidationUtil.equals(step, "end") ? "100" : ValidationUtil.equals(step, "running") ? "50" : "10";

        JSONObject event = new JSONObject();
        event.put("percent", percent);
        event.put("status", "running");
        event.put("logInfo", msg);
        event.put("time", DateUtils.toDateStr(DateUtils.format()));
        try {
            emqKeeper.getMqttClient().publish("/topicTable/solidify/" + (id.indexOf(',') != -1 ? id.split(",")[0] : id), event.toString().getBytes(), 0, false);
        } catch (MqttException e) {
            e.printStackTrace();
        }
    }

    /**
     * 导出插入语句
     */
    public StringBuilder getSelectSQL(
            List<RelationTreeModel> array,
            String tableName,
            List<TableColumn> columns,
            String agencyCode) {
        StringBuilder sql = new StringBuilder();
        if (array.size() == 1) {
            sql.append("SELECT * FROM ").append(array.get(0).getName()).append(" WHERE ");
            sql.append(array.get(0).getName()).append(".").append(array.get(0).getField());
            sql.append(" = '").append(agencyCode).append("' ;");
        } else {
            sql.append("SELECT ");
            int count = 0;
            for (TableColumn colum : columns) {
                if (count != 0) {
                    sql.append(",");
                }
                count++;
                sql.append(tableName).append(".").append(colum.getColumnName());
            }
            sql.append(" FROM ").append(array.get(0).getName());
            for (RelationTreeModel model : array) {
                if (!model.getParentName().equals("")) {
                    sql.append(" JOIN ").append(model.getName()).append(" ON ");
                    sql.append(model.getParentName()).append(".").append(model.getParentField()).append(" = ");
                    sql.append(model.getName()).append(".").append(model.getField());
                }
            }
            sql.append(" WHERE ").append(array.get(0).getName()).append(".").append(array.get(0).getField());
            sql.append(" = '").append(agencyCode).append("' ;");
        }
        return sql;
    }

    /**
     * 列表节点生成（递归）
     */
    public List<RelationTreeModel> createNodeList(List<RelationTreeModel> tree) {
        List<RelationTreeModel> result = new ArrayList<>();
        for (RelationTreeModel node : tree) {
            RelationTreeModel model = new RelationTreeModel();
            BeanUtils.copyProperties(node, model);
            model.setChildren(null);
            result.add(model);
            result.addAll(createNodeList(node.getChildren()));
        }
        return result;
    }

    /**
     * 树转化对象列表
     */
    public List<RelationTreeModel> createList(RelationTreeModel model) {
        List<RelationTreeModel> result = new ArrayList<>();
        RelationTreeModel temp = new RelationTreeModel();
        BeanUtils.copyProperties(model, temp);
        temp.setChildren(null);
        result.add(temp);
        result.addAll(createNodeList(model.getChildren()));
        return result;
    }

    /**
     * 根据表获取关联表集合
     */
    public List<RelationTreeModel> tableRelation(RelationTreeModel table, List<RelationTreeModel> list) {
        List<RelationTreeModel> result = new ArrayList<>();
        if (table.getParentName().equals("")) {
            result.add(table);
        } else {
            for (RelationTreeModel node : list) {
                if (node.getName().equals(table.getParentName())) {
                    result.addAll(tableRelation(node, list));
                    result.add(table);
                    break;
                }
            }
        }
        return result;
    }

    public void download(HttpServletResponse response, String fileName, String sqlFilePath) throws IOException {
        File f = new File(sqlFilePath);
        BufferedInputStream br = new BufferedInputStream(new FileInputStream(f));
        byte[] buf = new byte[1024];
        int len = 0;
        response.reset(); // 非常重要
        response.setContentType("application/x-msdownload");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        OutputStream out = response.getOutputStream();
        while ((len = br.read(buf)) > 0)
            out.write(buf, 0, len);
        br.close();
        out.close();
    }
}
