package com.yeejoin.amos.api.tool.face.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.tool.enums.PictureType;
import com.yeejoin.amos.api.tool.enums.SourceEnum;
import com.yeejoin.amos.api.tool.face.model.DataBaseLinkModel;
import com.yeejoin.amos.api.tool.face.model.ProjectModel;
import com.yeejoin.amos.api.tool.face.orm.entity.StudioResource;
import com.yeejoin.amos.api.tool.face.model.StudioResourceModel;
import com.yeejoin.amos.api.tool.face.orm.dao.StudioResourceMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.TableColumn;
import com.yeejoin.amos.api.tool.utils.DataBaseUtils;
import com.yeejoin.amos.api.tool.utils.DateUtils;
import com.yeejoin.amos.api.tool.utils.SqlHelper;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.*;
import java.sql.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <p>
 * 服务类
 * </p>
 *
 * @author 子杨
 * @since 2022-08-16
 */
@Component
public class StudioResourceService extends BaseService<StudioResourceModel, StudioResource, StudioResourceMapper> {

    /**
     * 数据库备份路径
     */
    public static final String BACKUP_PATH = "/db/";

    /**
     * 数据库备份文本前缀
     */
    public static String ONESQL_PREFIX = "";
    private static String SUFFIX = "sql";
    private static String BR = "\r\n";
    private static String SLASH = "/";
    private static String BRANCH = ";";
    private static String SPLIT = "`";
    private static String SPACE = " ";
    private static String INSERT_INTO = " INSERT INTO ";
    private static String CREATE_INTO = " CREATE TABLE ";
    private static String VALUES = "VALUES";
    private static String LEFTBRACE = "(";
    private static String RIGHTBRACE = ")";
    private static String QUOTES = "'";
    private static String COMMA = ",";
    private static String DISABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 0;\r\n";
    private static String ABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 1;\r\n";
    private static String DELIMITER = "###################################";

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    DataSource datasource;

    @Autowired
    private DataBaseLinkService dataBaseLinkService;

    @Autowired
    private SqlHelper sqlHelper;

    @Autowired
    EmqKeeper emqKeeper;

    /**
     * 列表查询 示例
     */
    public List<StudioResourceModel> queryForStudioResourceList(String resourceCode) {
        return this.queryForList("", false, resourceCode);
    }

    public void generateSQL(String resourceCode, String dimension, Long ipSeq, Map<String, Object> variables, HttpServletResponse response) {
        try {
//			if (resourceCode.equals("StudioApplication")){
//				ApplicationModel model = applicationService.queryBySeq(Long.valueOf(variables.get(dimension).toString()));
//				variables.put("agencyCode", model.getAgencyCode());
//			}
            List<StudioResourceModel> resourceList = queryForStudioResourceList(resourceCode);
            File directory = new File("");// 参数为空
            String coursePath = directory.getCanonicalPath();
            File parentFile = new File(coursePath).getParentFile();
            String backPath = parentFile.getCanonicalPath() + BACKUP_PATH;
            File sqlDirectory = new File(backPath);
            if (!sqlDirectory.exists()) {
                sqlDirectory.mkdir();
            }

            print(variables.get(dimension).toString(), "开始执行", "start");

            // 备份文件路径名称
            String fileName = (SourceEnum.IDX.getSource().equals(resourceCode.toLowerCase()) ? (resourceCode.toLowerCase() + "_") : "studio_") + DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
            String sqlFilePath = backPath + SLASH + fileName;
            File file = new File(sqlFilePath);

            FileOutputStream out;
            OutputStreamWriter writer = null;

            out = new FileOutputStream(file);
            writer = new OutputStreamWriter(out, "utf8");

            StringBuffer deleteSql = new StringBuffer();
            StringBuffer insertSql = new StringBuffer();

            for (StudioResourceModel model : resourceList) {
                if (!validationParameters(model, variables)) {
                    continue;
                }
                if (!ObjectUtils.isEmpty(model.getResourceDeleteSql())) {
                    String json = format(model.getResourceDeleteSql(), variables);
                    JSONObject dimensionData = JSONObject.parseObject(json);
                    String deleteAllSql = dimensionData.getString(dimension);
                    deleteAllSql.replaceAll(";", ";" + BR);
                    deleteSql.append(deleteAllSql);
                }
                if (!ObjectUtils.isEmpty(model.getResourceInsertSql())) {
                    String sql = buildInsertSql(model, dimension, ipSeq, variables);
                    if (!ObjectUtils.isEmpty(sql)) insertSql.append(sql);
                }
            }

            if (deleteSql.length() > 0) {
                print(variables.get(dimension).toString(), "开始创建delete语句...", "running");
                writer.write(BR + DELIMITER + BR);
                writer.write("/**" + BR + "* 删除历史资源数据 " + BR + "**/" + BR);
                writer.write(BR + DELIMITER + BR);
                writer.write(deleteSql.toString());
                writer.write(BR + BR + DELIMITER + BR);
                print(variables.get(dimension).toString(), "delete语句创建完成...", "running");
            }

            if (insertSql.length() > 0) {
                print(variables.get(dimension).toString(), "开始创建insert语句...", "running");
                writer.write(BR + DELIMITER + BR);
                writer.write("/**" + BR + "* 资源数据" + BR + "**/" + BR);
                writer.write(BR + DELIMITER + BR);
                writer.write(insertSql.toString());
                writer.write(BR + BR + DELIMITER + BR);
                print(variables.get(dimension).toString(), "insert语句创建完成...", "running");
            }
            writer.flush();
            writer.close();
            out.close();

            if (deleteSql.length() == 0 && insertSql.length() == 0) {
                print(variables.get(dimension).toString(), "该项目下数据路径字段为空，不支持导出...", "start");
                return;
            }
            download(response, fileName, sqlFilePath);
            print(variables.get(dimension).toString(), "执行结束", "end");
        } catch (IOException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void generateSQLByDatabaseName(String resourceCode, String dimension, String databaseName, Long ipSeq, Map<String, Object> variables, HttpServletResponse response) {
        try {
            DataBaseLinkModel dataBaseLinkModel = dataBaseLinkService.queryBySeq(ipSeq);
            //根据连接查询到数据库表名
            Connection connection = dataBaseLinkService.connectNewDatabase(dataBaseLinkModel);
//            List<String> list = DataBaseUtils.getList("select table_name from information_schema.tables where table_schema='" + dataBaseLinkModel.getPrefix()+""+databaseName + "';", connection);
            List<String> list = DataBaseUtils.getList("select table_name from information_schema.tables where table_schema='" +""+databaseName + "';", connection);
            List<StudioResourceModel> resourceList = queryForStudioResourceList(resourceCode);
            File directory = new File("");// 参数为空
            String coursePath = directory.getCanonicalPath();
            File parentFile = new File(coursePath).getParentFile();
            String backPath = parentFile.getCanonicalPath() + BACKUP_PATH;
            File sqlDirectory = new File(backPath);
            if (!sqlDirectory.exists()) {
                sqlDirectory.mkdir();
            }
            // 备份文件路径名称
//            String fileName = (SourceEnum.IDX.getSource().equals(resourceCode.toLowerCase()) ? (resourceCode.toLowerCase() + "_") : "studio_") + DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
            String fileName = databaseName+DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
            String sqlFilePath = backPath + SLASH + fileName;
            File file = new File(sqlFilePath);
            FileOutputStream out;
            OutputStreamWriter writer = null;
            out = new FileOutputStream(file);
            writer = new OutputStreamWriter(out, "utf8");
            StringBuffer deleteSql = new StringBuffer();
            for (String tableName : list) {
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS " +
                        "WHERE TABLE_NAME = '" + tableName + "' AND COLUMN_NAME = '" + "AGENCY_CODE" + "';");
                if (!rs.next()) {
                    continue;
                }
                deleteSql.append("DELETE FROM " + tableName + " WHERE AGENCY_CODE = '" + variables.get(dimension).toString() + "';" + BR);
                rs.close();
                statement.close();
            }
            StringBuffer insertSql = new StringBuffer();
            for (StudioResourceModel model : resourceList) {
                String sql = buildInsertSqlByDatabaseName(model, dimension, databaseName, list, ipSeq, variables);
                if (!ObjectUtils.isEmpty(sql))
                    insertSql.append(sql);
            }

            if (deleteSql.length() > 0) {
                print(variables.get(dimension).toString(), "开始创建delete语句...", "running");
                writer.write(BR + DELIMITER + BR);
                writer.write("/**" + BR + "* 删除历史资源数据 " + BR + "**/" + BR);
                writer.write(BR + DELIMITER + BR);
                writer.write(deleteSql.toString());
                writer.write(BR + BR + DELIMITER + BR);
                print(variables.get(dimension).toString(), "delete语句创建完成...", "running");
            }

            if (insertSql.length() > 0) {
                print(variables.get(dimension).toString(), "开始创建insert语句...", "running");
                writer.write(BR + DELIMITER + BR);
                writer.write("/**" + BR + "* 资源数据" + BR + "**/" + BR);
                writer.write(BR + DELIMITER + BR);
                writer.write(insertSql.toString());
                writer.write(BR + BR + DELIMITER + BR);
                print(variables.get(dimension).toString(), "insert语句创建完成...", "running");
            }

            writer.flush();
            writer.close();
            out.close();
            download(response, fileName, sqlFilePath);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }


    public void print(String id, String msg, String step) {
        String percent = "0";
        percent = ValidationUtil.equals(step, "end") ? "100" : ValidationUtil.equals(step, "running") ? "50" : "10";

        JSONObject event = new JSONObject();
        event.put("percent", percent);
        event.put("status", "running");
        event.put("logInfo", msg);
        event.put("time", DateUtils.toDateStr(DateUtils.format()));
        try {
            emqKeeper.getMqttClient().publish("/topicTable/solidify/" + (id.indexOf(',') != -1 ? id.split(",")[0] : id), event.toString().getBytes(), 0, false);
        } catch (MqttException e) {
            e.printStackTrace();
        }
    }

    private boolean validationParameters(StudioResourceModel model, Map<String, Object> variables) {
        String text = model.getResourceParams();
        JSONArray fields = JSONObject.parseArray(text);
        for (int i = 0; i < fields.size(); i++) {
            if (!variables.containsKey(fields.getJSONObject(i).getString("name"))) {
                return false;
            }
        }
        return true;
    }

    private String buildInsertSql(StudioResourceModel resource, String dimension, Long ipSeq, Map<String, Object> variables) throws SQLException {
        StringBuffer sbsql = new StringBuffer();

        String json = format(resource.getResourceInsertSql(), variables);
        JSONObject dimensionData = JSONObject.parseObject(json);
        JSONObject selectAllSql = dimensionData.getJSONObject(dimension);
        DataBaseLinkModel dataBaseLinkModel = dataBaseLinkService.queryBySeq(ipSeq);
        for (String tableName : selectAllSql.keySet()) {
            String selectsql = format(selectAllSql.getString(tableName), variables);
            if (dimension.equals("appSeq")) {
                dataBaseLinkModel.setDbName(dataBaseLinkModel.getDbName().replace("project", "studio"));
            } else if (dimension.equals("projectSeq")) {
                dataBaseLinkModel.setDbName(dataBaseLinkModel.getDbName().replace("project", "idx"));
            }
            Connection connection = dataBaseLinkService.connectNewDatabase(dataBaseLinkModel);
            if (ObjectUtils.isEmpty(selectAllSql.keySet())) {
                return "";
            }
            List<TableColumn> columns = DataBaseUtils.getTableColumn(tableName, connection);
            List<Map<String, Object>> dataList = DataBaseUtils.getMaps(selectsql, connection);
            sbsql.append(DataBaseUtils.getInsertSQL(dataList, columns, tableName));
            connection.close();
        }
        return sbsql.toString();
    }

    private String buildInsertSqlByDatabaseName(StudioResourceModel resource, String dimension, String databaseName, List<String> list, Long ipSeq, Map<String, Object> variables) throws SQLException {
        StringBuffer sbsql = new StringBuffer();
        DataBaseLinkModel dataBaseLinkModel = dataBaseLinkService.queryBySeq(ipSeq);
        dataBaseLinkModel.setDbName(databaseName);
        for (String tableName : list) {
            String selectsql = format("SELECT * from `" + tableName + "` WHERE AGENCY_CODE = '${agencyCode}';", variables);
            if (dimension.equals("appSeq")) {
                dataBaseLinkModel.setDbName(dataBaseLinkModel.getDbName().replace("project", "studio"));
            } else if (dimension.equals("projectSeq")) {
                dataBaseLinkModel.setDbName(dataBaseLinkModel.getDbName().replace("project", "idx"));
            }
            Connection connection = dataBaseLinkService.connectNewDatabase(dataBaseLinkModel);

            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS " +
                    "WHERE TABLE_NAME = '" + tableName + "' AND COLUMN_NAME = '" + "AGENCY_CODE" + "';");
            if (!rs.next()) {
                continue;
            }
            List<TableColumn> columns = DataBaseUtils.getTableColumn(tableName, connection);
            List<Map<String, Object>> dataList = DataBaseUtils.getMaps(selectsql, connection);
            sbsql.append(DataBaseUtils.getInsertSQL(dataList, columns, tableName));
            rs.close();
            statement.close();
            connection.close();
        }
        return sbsql.toString();
    }

    public static String format(String sqlTemplate, Map<String, Object> parameter) {
        StringSubstitutor ss = new StringSubstitutor(parameter);
        return ss.replace(sqlTemplate);
    }

    public void download(HttpServletResponse response, String fileName, String sqlFilePath) throws IOException {
        File f = new File(sqlFilePath);
        BufferedInputStream br = new BufferedInputStream(new FileInputStream(f));
        byte[] buf = new byte[1024];
        int len = 0;
        response.reset(); // 非常重要
        response.setContentType("application/x-msdownload");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        OutputStream out = response.getOutputStream();
        while ((len = br.read(buf)) > 0)
            out.write(buf, 0, len);
        br.close();
        out.close();
    }


    /**
     * 获取项目列表
     */
    public List<ProjectModel> getProjectList(Long ipSeq, String agencyCode) throws SQLException {
        DataBaseLinkModel model = dataBaseLinkService.queryBySeq(ipSeq);
        model.setDbName("amos_studio");
        Connection connection = dataBaseLinkService.connectNewDatabase(model);
        Statement sql = connection.createStatement();
        String sqlStr = "select SEQUENCE_NBR,PROJECT_NAME,AGENCY_CODE from  " + model.getPrefix() + "amos_studio" + model.getSuffix() + ".studio_project " +
                "where AGENCY_CODE = " + "'" + agencyCode + "'";
//        System.out.println(sqlStr);
        ResultSet resultSet = sql.executeQuery(sqlStr);
        ResultSetMetaData md = resultSet.getMetaData(); //获得结果集结构信息,元数据
        List<ProjectModel> listPm = new ArrayList<>();   //实例化一个list作为容器
        try {
            //循环赋值 添加ProjectMode到list
            while (resultSet.next()) {
                //每次循环都实例化一个user 用来储存属性
                ProjectModel pm = new ProjectModel();
                pm.setName(resultSet.getString("PROJECT_NAME"));
                pm.setSequenceNbr(resultSet.getString("SEQUENCE_NBR"));
                pm.setAgencyCode(resultSet.getString("AGENCY_CODE"));
                listPm.add(pm);
            }
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        } finally {
            //关闭资源
            connection.close();
        }

        return listPm;
    }


    public List<ProjectModel> getAppList(Long ipSeq, Long projectNbr) throws SQLException {
        DataBaseLinkModel model = dataBaseLinkService.queryBySeq(ipSeq);
        model.setDbName("amos_studio");
        Connection connection = dataBaseLinkService.connectNewDatabase(model);
        Statement sql = connection.createStatement();
        String sqlStr = "select SEQUENCE_NBR,APP_NAME,DESIGNER_TYPE from  " + model.getPrefix() + "amos_studio" + model.getSuffix() + ".studio_application " +
                "where PROJECT_SEQ = " + "'" + projectNbr + "'";
//        System.out.println(sqlStr);
        ResultSet resultSet = sql.executeQuery(sqlStr);
        ResultSetMetaData md = resultSet.getMetaData(); //获得结果集结构信息,元数据
        List<ProjectModel> listPm = new ArrayList<>();   //实例化一个list作为容器
        try {
            //循环赋值 添加ProjectMode到list
            while (resultSet.next()) {
                //每次循环都实例化一个user 用来储存属性
                ProjectModel pm = new ProjectModel();
                pm.setName(resultSet.getString("APP_NAME"));
                pm.setSequenceNbr(resultSet.getString("SEQUENCE_NBR"));
                pm.setDesignerThumb(PictureType.returnPath(resultSet.getString("DESIGNER_TYPE")));
                listPm.add(pm);
            }
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        } finally {
            //关闭资源
            connection.close();
        }

        return listPm;
    }

    public List<ProjectModel> getIdx(Long ipSeq, String agencyCode) throws SQLException {
        DataBaseLinkModel model = dataBaseLinkService.queryBySeq(ipSeq);
        model.setDbName("amos_idx");
        Connection connection = dataBaseLinkService.connectNewDatabase(model);
        Statement sql = connection.createStatement();
        String sqlStr = "select id,agencyCode,name,type from  amos_idx.idx_explorer " +
                "where agencyCode = '" + agencyCode + "' and type = 'project'";
//        System.out.println(sqlStr);
        ResultSet resultSet = sql.executeQuery(sqlStr);
        ResultSetMetaData md = resultSet.getMetaData(); //获得结果集结构信息,元数据
        List<ProjectModel> listPm = new ArrayList<>();   //实例化一个list作为容器
        try {
            //循环赋值 添加ProjectMode到list
            while (resultSet.next()) {
                //每次循环都实例化一个user 用来储存属性
                ProjectModel pm = new ProjectModel();
                pm.setName(resultSet.getString("name"));
                pm.setSequenceNbr(resultSet.getString("id"));
                pm.setAgencyCode(agencyCode);
                listPm.add(pm);
            }
            resultSet.close();
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        } finally {
            //关闭资源
            connection.close();
        }
        return listPm;
    }
}
