package com.yeejoin.amos.api.tool.controller;

import  com.yeejoin.amos.api.tool.face.model.AmosDemoModel;
import com.yeejoin.amos.api.tool.face.service.AmosDemoService;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * <p>
 * 测试 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2023-06-06
 */

@RestController
@TycloudResource(module = "iot", value = "amosDemo")
@RequestMapping(value = "/v1/iot/AmosDemo")
@Api(tags = "iot-测试")
public class AmosDemoResource {

    private final Logger logger = LogManager.getLogger(AmosDemoResource.class);
    @Autowired
    private AmosDemoService simpleService;


    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN)
    @ApiOperation(value = "创建")
    @RequestMapping(value = "", method = RequestMethod.POST)
    public ResponseModel<AmosDemoModel> create(@RequestBody AmosDemoModel model) {
        model = simpleService.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN)
    @ApiOperation(value = "更新")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    public ResponseModel<AmosDemoModel> update(
            @RequestBody AmosDemoModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(simpleService.updateWithModel(model));
    }

    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN)
    @ApiOperation(value = "查询单个对象")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.GET)
    public ResponseModel<AmosDemoModel> seleteOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(simpleService.queryBySeq(sequenceNbr));
    }


    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN)
    @ApiOperation(value = "分页查询")
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public ResponseModel<Page<AmosDemoModel>> queryForPage(
            @RequestParam(value = "agencyCode") String agencyCode,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) {
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(simpleService.queryForAmosDemoPage(page, agencyCode));
    }


    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "列表查询")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseModel selectForList(@RequestParam(value = "agencyCode") String agencyCode) {
        return ResponseHelper.buildResponse(simpleService.queryForAmosDemoList(agencyCode));
    }

}
