package com.yeejoin.amos.api.tool.face.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@JsonIgnoreProperties({"hibernateLazyInitializer","handler"})
public class AmosToolTemplateVoModel extends AmosToolTemplateModel {

    /**
     * 模板名称
     */
    private String templateName;
    /**
     * 场景类型
     */
    private String categoryScene;
    /**
     * 效果图
     */
    @ApiModelProperty(value = "效果图")
    protected String sketch;
    /**
     * 所属机构
     */
    private String agencyName;

    /**
     * 模板URL
     */
    private String templateLink;

    @ApiModelProperty(value = "效果图")
    private List<PictureModel> sketches = new ArrayList<>();
}
