package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.enums.SortType;
import com.yeejoin.amos.api.tool.face.model.*;
import com.yeejoin.amos.api.tool.face.orm.dao.AmosToolTemplateMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.AmosToolTemplate;
import com.yeejoin.amos.api.tool.utils.ConvertUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import javax.annotation.Resource;
import java.util.*;

@Component
public class AmosToolTemplateService extends BaseService<AmosToolTemplateModel,
        AmosToolTemplate, AmosToolTemplateMapper> {
    @Resource
    private AmosToolTemplateMapper amosToolTemplateMapper;

    @Autowired
    private DatabaseConnectionService databaseConnectionService;



    /**
     * 点击后查看次数加一
     */
    public boolean updateTimes(Long sequenceNbr) {
        return amosToolTemplateMapper.updateTimesById(sequenceNbr);
    }

    /**
     * 获取排序类型
     */
    private SortType getSortType(String miniSences) {
        return SortType.fromName(miniSences);
    }

    /**
     * 列表全部数据
     */

    public List<AmosToolTemplateModel> queryList(){
        return this.queryForList("" , false);
    }

    /**
     * 列表分页查询
     */
    public Page<AmosToolTemplateModel> queryForAmosToolPage(Page page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 统一处理
     */
    public List<AmosToolTemplateModel> query(String categoryScene, String miniSences) {
        SortType sortType = getSortType(miniSences);

        if ("全部".equals(categoryScene)) {
            return amosToolTemplateMapper.listAll(sortType.getField(), sortType.getDirection());
        } else {
            return amosToolTemplateMapper.queryByScenes(categoryScene, sortType.getField(), sortType.getDirection());
        }
    }
    /**
     * 生成随机UID
     */
    public String getUid() {
        UUID uuid = UUID.randomUUID();
        String str = uuid.toString();
        return str.replace("-", "");
    }
    /**
     * url转化图片
     */
    public List<PictureModel> urlToModel(String url) {
        List<PictureModel> pictureModels = new ArrayList<>();
        PictureModel pictureModel = new PictureModel("", this.getUid(), url, "done");
        pictureModels.add(pictureModel);
        return pictureModels;
    }
    /**
     * model转化VO
     */
    public AmosToolTemplateVoModel convertVoModel(AmosToolTemplateModel templateModel) {
        AmosToolTemplateVoModel tplVoModel = new AmosToolTemplateVoModel();
        BeanUtils.copyProperties(templateModel, tplVoModel);
        if (templateModel.getSketch() != null)
            tplVoModel.setSketches(this.urlToModel(templateModel.getSketch()));
        return tplVoModel;
    }
    /**
     * TplVoModel转化TplModel
     */
    public AmosToolTemplateModel convertModel(AmosToolTemplateVoModel amosToolTplVoModel) throws NoSuchFieldException, IllegalAccessException {
        AmosToolTemplateModel amosToolTemplateModel = new AmosToolTemplateModel();
        BeanUtils.copyProperties(amosToolTplVoModel, amosToolTemplateModel, "thumbs", "sketches", "contentStr");

        //判定sketch为空
        if (amosToolTplVoModel.getSketches().size() != 0) {
            amosToolTemplateModel.setSketch(ConvertUtil.objectListToUrl(amosToolTplVoModel.getSketches()));
        }

        return amosToolTemplateModel;
    }
    /**
     * 根据sequenceNbr获取模板并转化为VO
     */
    public AmosToolTemplateVoModel queryForTplVo(Long sequenceNbr) {
        AmosToolTemplateModel templateModel = this.queryBySeq(sequenceNbr);
        AmosToolTemplateVoModel templateVoModel = this.convertVoModel(templateModel);

        return templateVoModel;
    }



}
