package com.yeejoin.amos.api.tool.face.service;

import com.yeejoin.amos.api.tool.face.orm.entity.SceneCasesLoginRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @author     Gary.Li
 * @date    2023/12/20
 */

@Service
public class LoginForwardService {
    @Autowired
    RestTemplate restTemplate;

    @Value("${scene.loginUrl}")
    String loginUrl;

    @Value("${scene.loginId}")
    String loginId;

    @Value("${scene.plainPwd}")
    String plainPwd;

    public String querySceneLoginToken() {
        // String encryptedPwd = DesUtil.encode(plainPwd, "qaz");
        String encryptedPwd = "AC286A35E74D2DD2B09873DEA7813245";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        // 自定义标头
        headers.add("Product", "AMOS_STUDIO_WEB");
        SceneCasesLoginRequest sceneCasesLoginRequest = new SceneCasesLoginRequest("1699861158791_4736F10B-37AA-493F-9A50-80C6A720BAB9",
                loginId, encryptedPwd, false);
        HttpEntity<SceneCasesLoginRequest> entity = new HttpEntity<>(sceneCasesLoginRequest, headers);
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(loginUrl, entity, String.class);
        String resBody = responseEntity.getBody();
        if (resBody == null) {
            return "fail-to-get-token";
        }
        int start = resBody.indexOf("\"token\":\"") + 9;
        if (start == -1 + 9) {
            return "fail-to-get-token";
        }
        int end = start + 36;
        return resBody.substring(start, end);
    }
}
