package com.yeejoin.amos.api.tool.face.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.api.tool.enums.PictureType;
import com.yeejoin.amos.api.tool.enums.SourceEnum;
import com.yeejoin.amos.api.tool.face.model.DatabaseConnectionModel;
import com.yeejoin.amos.api.tool.face.model.ProjectModel;
import com.yeejoin.amos.api.tool.face.orm.entity.StudioResource;
import com.yeejoin.amos.api.tool.face.model.StudioResourceModel;
import com.yeejoin.amos.api.tool.face.orm.dao.StudioResourceMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.TableColumn;
import com.yeejoin.amos.api.tool.utils.AESUtils;
import com.yeejoin.amos.api.tool.utils.DatabaseUtils;
import com.yeejoin.amos.api.tool.utils.DateUtils;
import com.yeejoin.amos.api.tool.utils.SqlHelper;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.*;
import java.sql.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;


/**
 * <p>
 * 服务类
 * </p>
 *
 * @author 子杨
 * @since 2022-08-16
 */
@Component
public class StudioResourceService extends BaseService<StudioResourceModel, StudioResource, StudioResourceMapper> {

    /**
     * 数据库备份路径
     */
    public static final String BACKUP_PATH = "/db/";

    /**
     * 数据库备份文本前缀
     */
    public static String ONESQL_PREFIX = "";
    private static final String SUFFIX = "sql";
    private static final String BR = "\r\n";
    private static final String SLASH = "/";
    private static final String BRANCH = ";";
    private static final String SPLIT = "`";
    private static final String SPACE = " ";
    private static final String INSERT_INTO = " INSERT INTO ";
    private static final String CREATE_INTO = " CREATE TABLE ";
    private static final String VALUES = "VALUES";
    private static final String LEFTBRACE = "(";
    private static final String RIGHTBRACE = ")";
    private static final String QUOTES = "'";
    private static final String COMMA = ",";
    private static final String DISABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 0;\r\n";
    private static final String ABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 1;\r\n";
    private static final String DELIMITER = "###################################";

    /**
     * 导出设计器中大屏时分库查询 因为可能加yeeamos，这里不使用多数据源
     */
    public static final String databaseName1="amos_studio";
    public static final String databaseName2="amos_project";
    /**
     * amos-tool-library 下的studio_resource
     * 中的插入字段已有下列字段，在文本中用其他字符串替换，这里To表示真正要插入的表明
     */
    public static final String column1="morphic_screen";
    public static final String column1To="studio_application";
    public static final String column2="morphic_screen_scene";
    public static final String column2To="morphic_scene";
    public static final String appKey="APP_KEY";

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    DataSource datasource;

    @Autowired
    private DatabaseConnectionService databaseConnectionService;

    @Autowired
    private SqlHelper sqlHelper;

    @Autowired
    EmqKeeper emqKeeper;


    /**
     * 列表查询 示例
     */
    public List<StudioResourceModel> queryForStudioResourceList(String resourceCode) {
        return this.queryForList("", false, resourceCode);
    }

    public void generateSQL(String resourceCode, String dimension, Long ipSeq, Map<String, Object> variables, HttpServletResponse response) {
        try {
//			if (resourceCode.equals("StudioApplication")){
//				ApplicationModel model = applicationService.queryBySeq(Long.valueOf(variables.get(dimension).toString()));
//				variables.put("agencyCode", model.getAgencyCode());
//			}
            List<StudioResourceModel> resourceList = queryForStudioResourceList(resourceCode);
            File directory = new File("");// 参数为空
            String coursePath = directory.getCanonicalPath();
            File parentFile = new File(coursePath).getParentFile();
            String backPath = parentFile.getCanonicalPath() + BACKUP_PATH;
            File sqlDirectory = new File(backPath);
            if (!sqlDirectory.exists()) {
                sqlDirectory.mkdir();
            }

            print(variables.get(dimension).toString(), "开始执行", "start");

            // 备份文件路径名称
            String fileName = (SourceEnum.IDX.getSource().equals(resourceCode.toLowerCase()) ? (resourceCode.toLowerCase() + "_") : "studio_") + DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
            String sqlFilePath = backPath + SLASH + fileName;
            File file = new File(sqlFilePath);
            FileOutputStream out;
            OutputStreamWriter writer = null;
            out = new FileOutputStream(file);
            writer = new OutputStreamWriter(out, "utf8");

            String fileName2="project"+DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
            String sqlFilePath2 = backPath + SLASH + fileName2;
            File file2 = new File(sqlFilePath2);
            FileOutputStream out2;
            OutputStreamWriter writer2 = null;
            out2 = new FileOutputStream(file2);
            writer2 = new OutputStreamWriter(out2, "utf8");

            StringBuffer deleteSql = new StringBuffer();
            StringBuffer insertSql = new StringBuffer();

            for (StudioResourceModel model : resourceList) {
                if (!validationParameters(model, variables)) {
                    continue;
                }
                if (!ObjectUtils.isEmpty(model.getResourceDeleteSql())) {
                    String json = format(model.getResourceDeleteSql(), variables);
                    JSONObject dimensionData = JSONObject.parseObject(json);
                    JSONObject deleteAllSql = dimensionData.getJSONObject(dimension);
                    for (String tableName : deleteAllSql.keySet()) {
                        String delSql=(String)deleteAllSql.get(tableName);
                        deleteSql.append( delSql.replace(";", ";" + BR));
                    }
                }
                if (!ObjectUtils.isEmpty(model.getResourceInsertSql())) {
                    String sql = buildInsertSql(model, dimension, ipSeq, variables);
                    if (!ObjectUtils.isEmpty(sql)) insertSql.append(sql);
                }
            }


            Connection connection = this.getConnection(databaseConnectionService.queryBySeq(ipSeq),databaseName1);
            String sql="select * from studio_application where SEQUENCE_NBR="+variables.get("appSeq");
            List<Map<String, Object>> maps = DatabaseUtils.getMaps(sql, connection);
            String appKey="";
            String insertSql2="";
            if (maps!=null||maps.size()!=0){
                for (Map<String, Object> map : maps) {
                    // 遍历每一个Map
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        String key = entry.getKey();
                        if (key.equals(appKey)){
                            appKey =(String) map.get(key);
                        }
                    }
                }
                connection.close();
                Connection conn = this.getConnection(databaseConnectionService.queryBySeq(ipSeq),databaseName2);
                String projectSql="select * from privilege_permission where APP_CODE = '"+appKey+"'";
                List<Map<String, Object>> projectMaps = DatabaseUtils.getMaps(projectSql, conn);
                if (projectMaps!=null||projectMaps.size()!=0){
                    List<TableColumn> tableColumn = DatabaseUtils.getTableColumn("privilege_permission",conn);
                     insertSql2=DatabaseUtils.getInsertSQL(projectMaps, tableColumn, "privilege_permission").toString();
                }
                conn.close();
            }
            if (insertSql2.length() > 0) {
                print(variables.get(dimension).toString(), "开始创建insert语句...", "running");
                writer2.write(BR + DELIMITER + BR);
                writer2.write("/**" + BR + "* 资源数据" + BR + "**/" + BR);
                writer2.write(BR + DELIMITER + BR);
                writer2.write(insertSql2);
                writer2.write(BR + BR + DELIMITER + BR);
                print(variables.get(dimension).toString(), "insert语句创建完成...", "running");
            }


            if (deleteSql.length() > 0) {
                print(variables.get(dimension).toString(), "开始创建delete语句...", "running");
                writer.write(BR + DELIMITER + BR);
                writer.write("/**" + BR + "* 删除历史资源数据 " + BR + "**/" + BR);
                writer.write(BR + DELIMITER + BR);
                writer.write(deleteSql.toString());
                writer.write(BR + BR + DELIMITER + BR);
                print(variables.get(dimension).toString(), "delete语句创建完成...", "running");
            }

            if (insertSql.length() > 0) {
                print(variables.get(dimension).toString(), "开始创建insert语句...", "running");
                writer.write(BR + DELIMITER + BR);
                writer.write("/**" + BR + "* 资源数据" + BR + "**/" + BR);
                writer.write(BR + DELIMITER + BR);
                writer.write(insertSql.toString());
                writer.write(BR + BR + DELIMITER + BR);
                print(variables.get(dimension).toString(), "insert语句创建完成...", "running");
            }

            writer2.flush();
            writer.flush();
            writer.close();
            writer2.close();
            out.close();
            out2.close();

            if (deleteSql.length() == 0 && insertSql.length() == 0) {
                print(variables.get(dimension).toString(), "该项目下数据路径字段为空，不支持导出...", "start");
                return;
            }
            if (insertSql2.length()>0){
               downloadFilesAsZip(new String[]{sqlFilePath,sqlFilePath2},"output.zip",response);
            }else {
                download(response, fileName, sqlFilePath);
            }
            delExistFile(sqlFilePath,sqlFilePath2);
            print(variables.get(dimension).toString(), "执行结束", "end");
        } catch (IOException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void delExistFile(String sqlFilePath,String sqlFilePath2){
        File delStudio = new File(sqlFilePath);
        if (delStudio.exists()){
            delStudio.delete();
        }
        File delProject = new File(sqlFilePath2);
        if (delProject.exists()){
            delProject.delete();
        }
    }

    public void downloadFilesAsZip(String[] filePaths, String zipFileName,HttpServletResponse response) {
        try {
            // 创建一个临时文件输出流，用于写入压缩文件
            FileOutputStream fos = new FileOutputStream(zipFileName);
            ZipOutputStream zos = new ZipOutputStream(fos);

            // 循环遍历要添加到压缩文件中的文件
            for (String filePath : filePaths) {
                File file = new File(filePath);
                if (file.exists()) {
                    // 添加文件到压缩文件
                    ZipEntry entry = new ZipEntry(file.getName());
                    zos.putNextEntry(entry);
                    FileInputStream fis = new FileInputStream(file);
                    byte[] buffer = new byte[1024];
                    int len;
                    while ((len = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    fis.close();
                } else {
                    System.out.println("File not found: " + filePath);
                }
            }
            zos.closeEntry(); // 关闭压缩文件条目
            zos.close(); // 关闭压缩输出流
            fos.close(); // 关闭文件输出流

            // 将压缩文件发送到浏览器进行下载
            sendFileToBrowser(zipFileName,response);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendFileToBrowser(String fileName,HttpServletResponse response) throws IOException {
        String fileExtension = ""; // 如果需要设置特定文件类型，请在此处添加，例如 ".zip"
        fileName = fileName + fileExtension; // 例如 "example.zip"
        File downloadFile = new File(fileName); // 获取要下载的文件路径和名称
        response.setContentType("application/octet-stream"); // 设置响应内容类型为二进制流，适用于下载文件
        response.setHeader("Content-Disposition", "attachment; filename=\"" + downloadFile.getName() + "\""); // 设置响应头，指定要下载的文件名
        OutputStream outputStream = response.getOutputStream(); // 获取输出流，用于将文件写入响应中
        FileInputStream inputStream = new FileInputStream(downloadFile); // 打开文件输入流以读取要下载的文件内容
        byte[] buffer = new byte[4096]; // 创建一个缓冲区来存储从文件中读取的数据块，可以根据需要调整大小
        int bytesRead; // 用于存储从文件中读取的字节数
        while ((bytesRead = inputStream.read(buffer)) != -1) { // 将数据块写入响应输出流中，直到整个文件被读取完为止
            outputStream.write(buffer, 0, bytesRead); // 将数据块写入响应输出流中，直到整个文件被读取完为止
        }
        outputStream.flush(); // 刷新输出流，确保所有数据都被写入响应中，并关闭输出流和输入流。
        outputStream.close(); // 关闭输出流和输入流。这将释放与它们关联的所有系统资源。请注意，关闭流是一个好习惯，因为未关闭的流可能导致资源泄漏和其他问题。如果您在使用完流之后不立即关闭它们，您可能会在代码中留下潜在的错误或问题。因此，最好在完成使用流之后立即关闭它们。
    }


    /**
     * 连接数据库
     * @param model DataBaseLinkModel
     * @return 数据库连接
     */
    private static Connection getConnection(DatabaseConnectionModel model,String databaseName) {
        try {
            // 加载数据库驱动
            Class.forName("com.mysql.cj.jdbc.Driver");
            if (model.getPrefix() == null || model.getPrefix().isEmpty() || model.getPrefix().equals("null")) {
                model.setPrefix("");
            }
            if (model.getSuffix() == null || model.getSuffix().isEmpty() || model.getSuffix().equals("null")) {
                model.setSuffix("");
            }
            // 连接新增的数据库
            String dbUrl = "jdbc:mysql://" + model.getIp() + ":" + model.getPort() + "/" +
                    model.getPrefix() + databaseName + model.getSuffix();
            return DriverManager.getConnection(dbUrl, model.getUserName(), AESUtils.decrypt(model.getPassWord()));
        } catch (ClassNotFoundException e) {
            // 处理数据库驱动加载异常
            e.printStackTrace();
        } catch (SQLException e) {
            // 处理数据库连接异常
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void generateSQLByDatabaseName(String resourceCode, String dimension, String dbSeqs, Long ipSeq, Map<String, Object> variables, HttpServletResponse response) {
        try {
            DatabaseConnectionModel dataBaseConnectionModel = databaseConnectionService.queryBySeq(ipSeq);
            // 根据连接查询到数据库表名
            Connection connection = DatabaseUtils.getConnection(dataBaseConnectionModel);

            // 查询所有数据库
            List<String> allDbs = DatabaseUtils.getAllDatabaseNames(connection);
            List<String> databaseNames = new ArrayList<>();

            String[] queryDbSeqs = dbSeqs.split(",");  // 序号从1开始
            for (String queryDbSeq : queryDbSeqs) {
                int idx = Integer.parseInt(queryDbSeq);
                databaseNames.add(allDbs.get(idx - 1));
            }
            // 查询到需要导出多个，在databaseNames中，循环，多次下载
            // TODO 有bug，connection是同一个。。。
            for (String databaseName : databaseNames) {
                List<String> tableNames = DatabaseUtils.getList("select table_name from information_schema.tables where table_schema='" + databaseName + "';", connection);
                List<StudioResourceModel> resourceList = queryForStudioResourceList(resourceCode);
                File directory = new File("");// 参数为空
                String coursePath = directory.getCanonicalPath();
                File parentFile = new File(coursePath).getParentFile();
                String backPath = parentFile.getCanonicalPath() + BACKUP_PATH;
                File sqlDirectory = new File(backPath);
                if (!sqlDirectory.exists()) {
                    sqlDirectory.mkdir();
                }
                // 备份文件路径名称
                // String fileName = (SourceEnum.IDX.getSource().equals(resourceCode.toLowerCase()) ? (resourceCode.toLowerCase() + "_") : "studio_") + DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
                String fileName = databaseName + DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
                String sqlFilePath = backPath + SLASH + fileName;
                File file = new File(sqlFilePath);
                FileOutputStream out;
                OutputStreamWriter writer = null;
                out = new FileOutputStream(file);
                writer = new OutputStreamWriter(out, "utf8");
                StringBuffer deleteSql = new StringBuffer();
                for (String tableName : tableNames) {
                    Statement statement = connection.createStatement();
                    ResultSet rs = statement.executeQuery("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS " +
                            "WHERE TABLE_NAME = '" + tableName + "' AND COLUMN_NAME = '" + "AGENCY_CODE" + "';");
                    if (!rs.next()) {
                        continue;
                    }
                    deleteSql.append("DELETE FROM " + tableName + " WHERE AGENCY_CODE = '" + variables.get(dimension).toString() + "';" + BR);
                    rs.close();
                    statement.close();
                }
                StringBuffer insertSql = new StringBuffer();
                for (StudioResourceModel model : resourceList) {
                    String sql = buildInsertSqlByDatabaseName(model, dimension, databaseName, tableNames, ipSeq, variables);
                    if (!ObjectUtils.isEmpty(sql))
                        insertSql.append(sql);
                }

                if (deleteSql.length() > 0) {
                    print(variables.get(dimension).toString(), "开始创建delete语句...", "running");
                    writer.write(BR + DELIMITER + BR);
                    writer.write("/**" + BR + "* 删除历史资源数据 " + BR + "**/" + BR);
                    writer.write(BR + DELIMITER + BR);
                    writer.write(deleteSql.toString());
                    writer.write(BR + BR + DELIMITER + BR);
                    print(variables.get(dimension).toString(), "delete语句创建完成...", "running");
                }

                if (insertSql.length() > 0) {
                    print(variables.get(dimension).toString(), "开始创建insert语句...", "running");
                    writer.write(BR + DELIMITER + BR);
                    writer.write("/**" + BR + "* 资源数据" + BR + "**/" + BR);
                    writer.write(BR + DELIMITER + BR);
                    writer.write(insertSql.toString());
                    writer.write(BR + BR + DELIMITER + BR);
                    print(variables.get(dimension).toString(), "insert语句创建完成...", "running");
                }

                writer.flush();
                writer.close();
                out.close();
                download(response, fileName, sqlFilePath);
            }
            connection.close();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }


    public void print(String id, String msg, String step) {
        String percent = "0";
        percent = ValidationUtil.equals(step, "end") ? "100" : ValidationUtil.equals(step, "running") ? "50" : "10";

        JSONObject event = new JSONObject();
        event.put("percent", percent);
        event.put("status", "running");
        event.put("logInfo", msg);
        event.put("time", DateUtils.toDateStr(DateUtils.format()));
        try {
            emqKeeper.getMqttClient().publish("/topicTable/solidify/" + (id.indexOf(',') != -1 ? id.split(",")[0] : id), event.toString().getBytes(), 0, false);
        } catch (MqttException e) {
            e.printStackTrace();
        }
    }

    private boolean validationParameters(StudioResourceModel model, Map<String, Object> variables) {
        String text = model.getResourceParams();
        JSONArray fields = JSONObject.parseArray(text);
        for (int i = 0; i < fields.size(); i++) {
            if (!variables.containsKey(fields.getJSONObject(i).getString("name"))) {
                return false;
            }
        }
        return true;
    }

    private String buildInsertSql(StudioResourceModel resource, String dimension, Long ipSeq, Map<String, Object> variables) throws SQLException {
        StringBuffer sbsql = new StringBuffer();

        String json = format(resource.getResourceInsertSql(), variables);
        JSONObject dimensionData = JSONObject.parseObject(json);
        JSONObject selectAllSql = dimensionData.getJSONObject(dimension);

        DatabaseConnectionModel dataBaseConnectionModel = databaseConnectionService.queryBySeq(ipSeq);
        for (String tableName : selectAllSql.keySet()) {
            String selectsql = format(selectAllSql.getString(tableName), variables);
            if (dimension.equals("appSeq")) {
                dataBaseConnectionModel.setDbName(dataBaseConnectionModel.getDbName().replace("project", "studio"));
            } else if (dimension.equals("projectSeq")) {
                dataBaseConnectionModel.setDbName(dataBaseConnectionModel.getDbName().replace("project", "idx"));
            }
            Connection connection = DatabaseUtils.getConnection(dataBaseConnectionModel);
            if (ObjectUtils.isEmpty(selectAllSql.keySet())) {
                return "";
            }
            if (tableName.equals(column1)){
                tableName=column1To;
            }
            if (tableName.equals(column2)){
                tableName=column2To;
            }
            List<TableColumn> columns = DatabaseUtils.getTableColumn(tableName, connection);
            List<Map<String, Object>> dataList = DatabaseUtils.getMaps(selectsql, connection);
            sbsql.append(DatabaseUtils.getInsertSQL(dataList, columns, tableName));
            connection.close();
        }
        return sbsql.toString();
    }

    private String buildInsertSqlByDatabaseName(StudioResourceModel resource, String dimension, String databaseName, List<String> list, Long ipSeq, Map<String, Object> variables) throws SQLException {
        StringBuffer sbsql = new StringBuffer();
        DatabaseConnectionModel dataBaseConnectionModel = databaseConnectionService.queryBySeq(ipSeq);
        dataBaseConnectionModel.setDbName(databaseName);
        for (String tableName : list) {
            String selectsql = format("SELECT * from `" + tableName + "` WHERE AGENCY_CODE = '${agencyCode}';", variables);
            if (dimension.equals("appSeq")) {
                dataBaseConnectionModel.setDbName(dataBaseConnectionModel.getDbName().replace("project", "studio"));
            } else if (dimension.equals("projectSeq")) {
                dataBaseConnectionModel.setDbName(dataBaseConnectionModel.getDbName().replace("project", "idx"));
            }
            Connection connection = DatabaseUtils.getConnection(dataBaseConnectionModel);

            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS " +
                    "WHERE TABLE_NAME = '" + tableName + "' AND COLUMN_NAME = '" + "AGENCY_CODE" + "';");
            if (!rs.next()) {
                continue;
            }
            List<TableColumn> columns = DatabaseUtils.getTableColumn(tableName, connection);
            List<Map<String, Object>> dataList = DatabaseUtils.getMaps(selectsql, connection);
            sbsql.append(DatabaseUtils.getInsertSQL(dataList, columns, tableName));
            rs.close();
            statement.close();
            connection.close();
        }
        return sbsql.toString();
    }

    public static String format(String sqlTemplate, Map<String, Object> parameter) {
        StringSubstitutor ss = new StringSubstitutor(parameter);
        return ss.replace(sqlTemplate);
    }

    public void download(HttpServletResponse response, String fileName, String sqlFilePath) throws IOException {
        File f = new File(sqlFilePath);
        BufferedInputStream br = new BufferedInputStream(new FileInputStream(f));
        byte[] buf = new byte[1024];
        int len = 0;
        response.reset(); // 非常重要
        response.setContentType("application/x-msdownload");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        OutputStream out = response.getOutputStream();
        while ((len = br.read(buf)) > 0)
            out.write(buf, 0, len);
        br.close();
        out.close();
    }


    /**
     * 获取项目列表
     */
    public List<ProjectModel> getProjectList(Long ipSeq, String agencyCode) throws SQLException {
        DatabaseConnectionModel model = databaseConnectionService.queryBySeq(ipSeq);
        model.setDbName("amos_studio");
        Connection connection = DatabaseUtils.getConnection(model);
        Statement sql = connection.createStatement();
        String sqlStr = "select SEQUENCE_NBR,PROJECT_NAME,AGENCY_CODE from  " + model.getPrefix() + "amos_studio" + model.getSuffix() + ".studio_project " +
                "where AGENCY_CODE = " + "'" + agencyCode + "'";
//        System.out.println(sqlStr);
        ResultSet resultSet = sql.executeQuery(sqlStr);
        ResultSetMetaData md = resultSet.getMetaData(); // 获得结果集结构信息,元数据
        List<ProjectModel> listPm = new ArrayList<>();   // 实例化一个list作为容器
        try {
            // 循环赋值 添加ProjectMode到list
            while (resultSet.next()) {
                // 每次循环都实例化一个user 用来储存属性
                ProjectModel pm = new ProjectModel();
                pm.setName(resultSet.getString("PROJECT_NAME"));
                pm.setSequenceNbr(resultSet.getString("SEQUENCE_NBR"));
                pm.setAgencyCode(resultSet.getString("AGENCY_CODE"));
                listPm.add(pm);
            }
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        } finally {
            // 关闭资源
            connection.close();
        }

        return listPm;
    }


    public List<ProjectModel> getAppList(Long ipSeq, Long projectNbr) throws SQLException {
        DatabaseConnectionModel model = databaseConnectionService.queryBySeq(ipSeq);
        model.setDbName("amos_studio");
        Connection connection = DatabaseUtils.getConnection(model);
        Statement sql = connection.createStatement();
        String sqlStr = "select SEQUENCE_NBR,APP_NAME,DESIGNER_TYPE from  " + model.getPrefix() + "amos_studio" + model.getSuffix() + ".studio_application " +
                "where PROJECT_SEQ = " + "'" + projectNbr + "'";
//        System.out.println(sqlStr);
        ResultSet resultSet = sql.executeQuery(sqlStr);
        ResultSetMetaData md = resultSet.getMetaData(); // 获得结果集结构信息,元数据
        List<ProjectModel> listPm = new ArrayList<>();   // 实例化一个list作为容器
        try {
            // 循环赋值 添加ProjectMode到list
            while (resultSet.next()) {
                // 每次循环都实例化一个user 用来储存属性
                ProjectModel pm = new ProjectModel();
                pm.setName(resultSet.getString("APP_NAME"));
                pm.setSequenceNbr(resultSet.getString("SEQUENCE_NBR"));
                pm.setDesignerThumb(PictureType.returnPath(resultSet.getString("DESIGNER_TYPE")));
                listPm.add(pm);
            }
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        } finally {
            // 关闭资源
            connection.close();
        }

        return listPm;
    }

    public List<ProjectModel> getIdx(Long ipSeq, String agencyCode) throws SQLException {
        DatabaseConnectionModel model = databaseConnectionService.queryBySeq(ipSeq);
        model.setDbName("amos_idx");
        Connection connection = DatabaseUtils.getConnection(model);
        Statement sql = connection.createStatement();
        String sqlStr = "select id,agencyCode,name,type from  amos_idx.idx_explorer " +
                "where agencyCode = '" + agencyCode + "' and type = 'project'";
//        System.out.println(sqlStr);
        ResultSet resultSet = sql.executeQuery(sqlStr);
        ResultSetMetaData md = resultSet.getMetaData(); // 获得结果集结构信息,元数据
        List<ProjectModel> listPm = new ArrayList<>();   // 实例化一个list作为容器
        try {
            // 循环赋值 添加ProjectMode到list
            while (resultSet.next()) {
                // 每次循环都实例化一个user 用来储存属性
                ProjectModel pm = new ProjectModel();
                pm.setName(resultSet.getString("name"));
                pm.setSequenceNbr(resultSet.getString("id"));
                pm.setAgencyCode(agencyCode);
                listPm.add(pm);
            }
            resultSet.close();
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        } finally {
            // 关闭资源
            connection.close();
        }
        return listPm;
    }
}
