package com.yeejoin.amos.api.tool.face.service;

// import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.ToolLibraryDetailModel;
import com.yeejoin.amos.api.tool.face.model.ToolLibraryModel;
import com.yeejoin.amos.api.tool.face.model.ToolLibraryTreeModel;
import com.yeejoin.amos.api.tool.face.orm.dao.MorphicWidgetGroupMapper;
import com.yeejoin.amos.api.tool.face.orm.dao.ToolLibraryMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.MorphicWidgetGroup;
import com.yeejoin.amos.api.tool.face.orm.entity.TableColumn;
import com.yeejoin.amos.api.tool.face.orm.entity.ToolLibrary;
import com.yeejoin.amos.api.tool.utils.DatabaseUtils;
import com.yeejoin.amos.api.tool.utils.SqlExportUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.*;

@Service
// @DS("amos-studio")
public class ToolLibraryService extends BaseService<ToolLibraryModel, ToolLibrary, ToolLibraryMapper> {

    @Autowired
    @Qualifier("dataSource-amos-studio")
    private DataSource dataSource;

    /**
     * 由一级到二级
     */
    public List<ToolLibraryTreeModel> queryForComponentList(String designer) throws SQLException {
        Connection connection = dataSource.getConnection();
        List<Map<String, Object>> displayMaps = DatabaseUtils.getMaps
                ("select display_name, DESIGNER_TYPE,SEQUENCE_NBR,parent from morphic_widget_group where DESIGNER_TYPE " +
                        "= '" + designer + "' and is_delete!=1;", connection);
        connection.close();

        List<ToolLibraryTreeModel> displayLists = new ArrayList<>();
        for (Map<String, Object> map : displayMaps) {
            ToolLibraryTreeModel model = new ToolLibraryTreeModel();
            model.setDesignerName(map.get("display_name").toString());
            model.setDesignerType(map.get("DESIGNER_TYPE").toString());
            model.setId(Long.valueOf(map.get("SEQUENCE_NBR").toString()));
            model.setParentId(Long.valueOf(map.get("parent").toString()));
            displayLists.add(model);
        }
        // 新建一个用于接收数据的list
        List<ToolLibraryTreeModel> resultList = new ArrayList<>();
        for (ToolLibraryTreeModel result : displayLists) {
            if (result.getParentId() == 0) {
                // 调用方法给子类添加数据
                resultList.add(getMenuTree(result, displayLists));
            }
        }
        return resultList;
    }

    private ToolLibraryTreeModel getMenuTree(ToolLibraryTreeModel result, List<ToolLibraryTreeModel> list) {
        for (ToolLibraryTreeModel treeModel : list) {
            // 如果父类主键等于传过来实体类的ID
            if (treeModel.getParentId().equals(result.getId())) {
                if (result.getChildren() == null) {
                    result.setChildren(new ArrayList<>());
                }
                // 递归调用
                result.getChildren().add(getMenuTree(treeModel, list));
            }
        }
        return result;
    }

    /**
     * 由二级到三级
     */
    public Page<ToolLibraryDetailModel> queryForComponentListDetails(Page<ToolLibraryDetailModel> page, String sequenceNbr)
            throws SQLException {
        Connection connection = dataSource.getConnection();
        // 先查当前节点的parent，看是不是0，从而判断在叶子节点还是父节点
        List<Map<String, Object>> clickedNodeMaps = DatabaseUtils.getMaps(
                "select SEQUENCE_NBR, parent, DESIGNER_TYPE, display_name " +
                        "from morphic_widget_group " +
                        "where is_delete != 1 and SEQUENCE_NBR = " + sequenceNbr, connection);
        String parent = clickedNodeMaps.get(0).get("parent").toString();
        List<Map<String, Object>> displayTools = new ArrayList<>();
        if (parent.equals("0")) {
            // 父节点
            // 查询所有表中parent==sequenceNbr的行数据
            List<Map<String, Object>> displayMaps = DatabaseUtils.getMaps(
                    "select SEQUENCE_NBR, parent, DESIGNER_TYPE, display_name " +
                            "from morphic_widget_group " +
                            "where is_delete != 1 and parent = " + sequenceNbr, connection);
            for (Map<String, Object> map : displayMaps) {
                String seqNbr = map.get("SEQUENCE_NBR").toString();
                displayTools.addAll(DatabaseUtils.getMaps(
                        "select SEQUENCE_NBR, category, component_key, name, thumb, descr " +
                        "from morphic_widget where is_delete != 1 and group_id = " + seqNbr, connection));
            }
        } else {
            // 叶子节点
            // 查询morphic_widget表中，group_id为sequenceNbr的所有工具数据
            displayTools.addAll(DatabaseUtils.getMaps(
                    "select SEQUENCE_NBR, category, component_key, name, thumb, descr " +
                            "from morphic_widget " +
                            "where is_delete != 1 and group_id = " + sequenceNbr, connection));
        }
        connection.close();

        List<ToolLibraryDetailModel> records = new ArrayList<>();
        for (Map<String, Object> map : displayTools) {
            ToolLibraryDetailModel model = new ToolLibraryDetailModel();
            model.setSequenceNbr(Long.valueOf(map.get("SEQUENCE_NBR").toString()));
            model.setCategory(map.get("category").toString());
            model.setComponentKey(map.get("component_key").toString());
            model.setName(map.get("name").toString());
            model.setThumb(map.get("thumb").toString());
            model.setDescr((String) Optional.ofNullable(map.get("descr")).orElse("无"));
            records.add(model);
        }
        // 封装Page
        long current = page.getCurrent();
        long size = page.getSize();
        if (!ValidationUtil.isEmpty(records)) {
            page.setTotal(records.size());
            page.setCurrent(current);
            page.setSize(size);
            // 只返回records中一页内的内容
            long start = (current - 1) * size;
            page.setRecords(records.subList((int) start, (int) Math.min(start + size, records.size())));
        }
        return page;
    }

    /**
     * 导出一级SQL
     */
    public void exportDesignerSQL(String id, HttpServletResponse httpServletResponse) {
        try {
            Connection connection = dataSource.getConnection();
            List<Map<String, Object>> resultMaps = DatabaseUtils.getMaps("select * from " +
                    "  (select SEQUENCE_NBR from morphic_widget_group " +
                    "  where DESIGNER_TYPE='" + id + "' and is_delete!=1) as t\n" +
                    "  inner join morphic_widget mw on mw.group_id=t.SEQUENCE_NBR", connection);
            List<TableColumn> tableColumn = DatabaseUtils.getTableColumn("morphic_widget", connection);
            StringBuffer insertSql = DatabaseUtils.getInsertSQL(resultMaps, tableColumn, "morphic_widget");
            connection.close();
            exportDownload(id, insertSql, httpServletResponse);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 导出组件中的工具的SQL（二级）
     */
    public void exportComponentSQL(String sequenceNbr, HttpServletResponse httpServletResponse) {
        try {
            Connection connection = dataSource.getConnection();
            // 先查当前节点的parent，看是不是0，从而判断在叶子节点还是父节点
            List<Map<String, Object>> clickedNodeMaps = DatabaseUtils.getMaps(
                    "select SEQUENCE_NBR, parent, DESIGNER_TYPE, display_name " +
                            "from morphic_widget_group " +
                            "where is_delete != 1 and SEQUENCE_NBR = " + sequenceNbr, connection);
            String parent = clickedNodeMaps.get(0).get("parent").toString();
            String sql;
            if (parent.equals("0")) {
                // 父节点
                sql = "SELECT * FROM morphic_widget\n" +
                        "WHERE is_delete != 1 and group_id IN (\n" +
                        "\tSELECT SEQUENCE_NBR\n" +
                        "\tFROM morphic_widget_group\n" +
                        "\twhere is_delete != 1 and parent = " + sequenceNbr +
                        ");";
            } else {
                // 叶子节点
                sql = "SELECT * FROM morphic_widget\n" +
                        "WHERE is_delete!=1 AND group_id = " + sequenceNbr + ";";
            }
            List<Map<String, Object>> resultMaps = DatabaseUtils.getMaps(sql, connection);
            List<TableColumn> tableColumn = DatabaseUtils.getTableColumn("morphic_widget", connection);
            StringBuffer insertSql = DatabaseUtils.getInsertSQL(resultMaps, tableColumn, "morphic_widget");
            connection.close();

            // 下载.sql文件
            exportDownload(sequenceNbr + "-", insertSql, httpServletResponse);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 导出组件中的工具的SQL（三级）
     */
    public void exportToolSQL(String sequenceNbrs, HttpServletResponse httpServletResponse) {
        String[] split = sequenceNbrs.split(",");
        String sequenceNbres = Arrays.toString(split);
        sequenceNbres = sequenceNbres.substring(1, sequenceNbres.length() - 1);
        try {
            String sql = "SELECT *\n" +
                    "FROM morphic_widget\n" +
                    "WHERE is_delete!=1 AND SEQUENCE_NBR IN (" + sequenceNbres + ");";
            Connection connection = dataSource.getConnection();
            List<Map<String, Object>> resultMaps = DatabaseUtils.getMaps(sql, connection);
            List<TableColumn> tableColumn = DatabaseUtils.getTableColumn("morphic_widget", connection);
            StringBuffer insertSql = DatabaseUtils.getInsertSQL(resultMaps, tableColumn, "morphic_widget");
            connection.close();
            exportDownload("tool", insertSql, httpServletResponse);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportDownload(String id, StringBuffer insertSql, HttpServletResponse httpServletResponse) throws IOException {
        File directory = new File("");// 参数为空
        String coursePath = directory.getCanonicalPath();
        File parentFile = new File(coursePath).getParentFile();
        String backPath = parentFile.getCanonicalPath() + SqlExportUtils.BACKUP_PATH;
        File sqlDirectory = new File(backPath);
        if (!sqlDirectory.exists()) {
            sqlDirectory.mkdir();
        }
        // 备份文件路径名称
        String fileName = id + DateFormatUtils.format(new Date(), "yyyyMMddHHmmss") + "." + SqlExportUtils.SUFFIX;
        String sqlFilePath = backPath + SqlExportUtils.SLASH + fileName;
        File file = new File(sqlFilePath);
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        if (insertSql.length() > 0) {
            writer.write(SqlExportUtils.BR + SqlExportUtils.DELIMITER + SqlExportUtils.BR);
            writer.write("/**" + SqlExportUtils.BR + "* 资源数据" + SqlExportUtils.BR + "**/" + SqlExportUtils.BR);
            writer.write(SqlExportUtils.BR + SqlExportUtils.DELIMITER + SqlExportUtils.BR);
            writer.write(insertSql.toString());
            writer.write(SqlExportUtils.BR + SqlExportUtils.BR + SqlExportUtils.DELIMITER + SqlExportUtils.BR);
        }
        writer.flush();
        writer.close();

        download(httpServletResponse, fileName, sqlFilePath);
    }

    private void download(HttpServletResponse response, String fileName, String sqlFilePath) throws IOException {
        File f = new File(sqlFilePath);
        BufferedInputStream br = new BufferedInputStream(new FileInputStream(f));
        byte[] buf = new byte[1024];
        int len;
        response.reset(); // 非常重要
        response.setContentType("application/x-msdownload");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        OutputStream out = response.getOutputStream();
        while ((len = br.read(buf)) > 0)
            out.write(buf, 0, len);
        br.close();
        out.close();
    }


}
