package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.AmosToolTemplateModel;
import com.yeejoin.amos.api.tool.face.service.AmosToolTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

@CrossOrigin
@RestController
@RequestMapping(value = "/scene")
@Api(tags = "场景展示Api")
public class AmosToolTemplateController {

    @Resource
    private AmosToolTemplateService amosToolTemplateService;

    /**
     * 添加单个记录
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @PostMapping("/save")
    @ApiOperation(value = "新增", notes = "新增")
    public ResponseModel<AmosToolTemplateModel> create(@RequestBody AmosToolTemplateModel model) {
        model = amosToolTemplateService.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据 sequenceNbr 删除
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @DeleteMapping("/{sequenceNbr}")
    @ApiOperation(value = "删除")
    public ResponseModel<Boolean> deleteById(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(amosToolTemplateService.deleteBySeq(sequenceNbr));
    }

    /**
     * 根据 sequenceNbr 批量删除
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/delete/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr批量删除", notes = "根据sequenceNbr批量删除")
    public ResponseModel<Boolean> deleteModelsBySequenceNbr(@PathVariable(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(amosToolTemplateService.removeByIds(Arrays.asList(StringUtil.string2Array(sequenceNbr))));
    }

    /**
     * 根据 sequenceNbr 编辑单个记录
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "编辑")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    public ResponseModel<AmosToolTemplateModel> update(
            @RequestBody AmosToolTemplateModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(amosToolTemplateService.updateWithModel(model));
    }

    /**
     * 根据 sequenceNbr 查询单个记录
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "查询单个对象")
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.GET)
    public ResponseModel<AmosToolTemplateModel> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(amosToolTemplateService.queryBySeq(sequenceNbr));
    }

    /**
     * 根据字段查询
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "查询大全")
    @PostMapping("/select/all")
    public ResponseModel<List<AmosToolTemplateModel>> query(@RequestParam(value = "categoryScene") String categoryScene,
                                                            @RequestParam(value = "miniSences") String miniSences) {
        return ResponseHelper.buildResponse(amosToolTemplateService.query(categoryScene, miniSences));
    }

    /**
     * 列表所有记录
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation("查询所有")
    @PostMapping("/every")
    public ResponseModel<List<AmosToolTemplateModel>> selectForList() {
        return ResponseHelper.buildResponse(amosToolTemplateService.queryList());
    }

    /**
     * 列表分页查询
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "分页查询")
    @GetMapping(value = "/page")
    public ResponseModel<Page<AmosToolTemplateModel>> queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) {
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(amosToolTemplateService.queryForAmosToolPage(page));
    }

    /**
     * 点击后根据 sequenceNbr 查看次数加一
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "点击查看次数加一")
    @PutMapping("/update")
    public ResponseModel<Boolean> updateById(@RequestParam(value = "templateId") Long sequenceNbr) {
        return ResponseHelper.buildResponse(amosToolTemplateService.updateTimes(sequenceNbr));
    }
}
