package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.enums.SortType;
import com.yeejoin.amos.api.tool.face.model.AmosToolTemplateModel;
import com.yeejoin.amos.api.tool.face.orm.dao.AmosToolTemplateMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.AmosToolTemplate;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import javax.annotation.Resource;
import java.util.List;

@Component
public class AmosToolTemplateService extends BaseService<AmosToolTemplateModel,
        AmosToolTemplate, AmosToolTemplateMapper> {
    @Resource
    private AmosToolTemplateMapper amosToolTemplateMapper;


    /**
     * 点击后查看次数加一
     */
    public boolean updateTimes(Long sequenceNbr) {
        return amosToolTemplateMapper.updateTimesById(sequenceNbr);
    }

    /**
     * 获取排序类型
     */
    private SortType getSortType(String miniSences) {
        return SortType.fromName(miniSences);
    }

    /**
     * 列表全部数据
     */

    public List<AmosToolTemplateModel> queryList(){
        return this.queryForList("" , false);
    }

    /**
     * 列表分页查询
     */
    public Page<AmosToolTemplateModel> queryForAmosToolPage(Page page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 统一处理
     */
    public List<AmosToolTemplateModel> query(String categoryScene, String miniSences) {
        SortType sortType = getSortType(miniSences);

        if ("全部".equals(categoryScene)) {
            return amosToolTemplateMapper.listAll(sortType.getField(), sortType.getDirection());
        } else {
            return amosToolTemplateMapper.queryByScenes(categoryScene, sortType.getField(), sortType.getDirection());
        }
    }
}
