package com.yeejoin.amos.api.tool.face.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.enums.SourceEnum;
import com.yeejoin.amos.api.tool.face.model.StudioResource;
import com.yeejoin.amos.api.tool.face.model.StudioResourceModel;
import com.yeejoin.amos.api.tool.face.orm.dao.StudioResourceMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.TableColumn;
import com.yeejoin.amos.api.tool.utils.DateUtils;
import com.yeejoin.amos.api.tool.utils.SqlHelper;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.io.*;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author 子杨
 * @since 2022-08-16
 */
@Component
public class StudioResourceService extends BaseService<StudioResourceModel, StudioResource, StudioResourceMapper> {

	/**
	 * 数据库备份路径
	 */
	public static final String BACKUP_PATH = "/db/";

	/**
	 * 数据库备份文本前缀
	 */
	public static String ONESQL_PREFIX = "";
	private static String SUFFIX = "sql";
	private static String BR = "\r\n";
	private static String SLASH = "/";
	private static String BRANCH = ";";
    private static String SPLIT = "`";
    private static String SPACE = " ";
    private static String INSERT_INTO = " INSERT INTO ";
    private static String CREATE_INTO = " CREATE TABLE ";
    private static String VALUES = "VALUES";
    private static String LEFTBRACE = "(";
    private static String RIGHTBRACE = ")";
    private static String QUOTES = "'";
    private static String COMMA = ",";
    private static String DISABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 0;\r\n";
    private static String ABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 1;\r\n";
	private static String DELIMITER = "###################################";
	@Autowired
	JdbcTemplate jdbcTemplate;
	@Autowired
	DataSource datasource;

	@Autowired
	private SqlHelper sqlHelper;

	@Autowired
	EmqKeeper emqKeeper;

	/**
	 * 分页查询
	 */
	public Page<StudioResourceModel> queryForStudioResourcePage(Page page, String agencyCode) {
		return this.queryForPage(page, null, false, agencyCode);
	}

	/**
	 * 列表查询 示例
	 */
	public List<StudioResourceModel> queryForStudioResourceList(String resourceCode) {
		return this.queryForList("", false, resourceCode);
	}

	public void generateSQL(String resourceCode, String dimension,Map<String, Object> variables, HttpServletResponse response) {
		try {
//			if (resourceCode.equals("StudioApplication")){
//				ApplicationModel model = applicationService.queryBySeq(Long.valueOf(variables.get(dimension).toString()));
//				variables.put("agencyCode", model.getAgencyCode());
//			}
			List<StudioResourceModel> resourceList = queryForStudioResourceList(resourceCode);
			File directory = new File("");// 参数为空
			String coursePath = directory.getCanonicalPath();
			File parentFile = new File(coursePath).getParentFile();
			String backPath = parentFile.getCanonicalPath() + BACKUP_PATH;
			File sqlDirectory = new File(backPath);
			if (!sqlDirectory.exists()) {
				sqlDirectory.mkdir();
			}

			print(variables.get(dimension).toString(),"开始执行","start");

			// 备份文件路径名称
			String fileName = (SourceEnum.IDX.getSource().equals(resourceCode.toLowerCase()) ? (resourceCode.toLowerCase() + "_") : "studio_") + DateFormatUtils.format(new Date(), "yyyyMMdd") + "." + SUFFIX;
			String sqlFilePath = backPath + SLASH + fileName;
			File file = new File(sqlFilePath);

			FileOutputStream out;
			OutputStreamWriter writer = null;

			out = new FileOutputStream(file);
			writer = new OutputStreamWriter(out, "utf8");

			StringBuffer deleteSql = new StringBuffer();
			StringBuffer insertSql = new StringBuffer();

			for (StudioResourceModel model : resourceList) {
				if (!validationParameters(model, variables)) {
					continue;
				}
				if (!ObjectUtils.isEmpty(model.getResourceDeleteSql())) {
					String json = format(model.getResourceDeleteSql(), variables);
					JSONObject dimensionData = JSONObject.parseObject(json);
					String deleteAllSql = dimensionData.getString(dimension);
					deleteAllSql.replaceAll(";", ";" + BR);
					deleteSql.append(deleteAllSql).append(BRANCH).append(BR);
				}
				if (!ObjectUtils.isEmpty(model.getResourceInsertSql())) {
					String sql = buildInsertSql(model,dimension,  variables);
					if (!ObjectUtils.isEmpty(sql))  insertSql.append(sql);
				}
			}

			if (deleteSql.length() > 0) {
				print(variables.get(dimension).toString(),"开始创建delete语句...","running");
				writer.write(BR + DELIMITER + BR);
				writer.write("/**" + BR + "* 删除历史资源数据 " + BR + "**/" + BR);
				writer.write(BR + DELIMITER + BR);
				writer.write(deleteSql.toString());
				writer.write(BR + BR + DELIMITER + BR);
				print(variables.get(dimension).toString(),"delete语句创建完成...","running");
			}

			if (insertSql.length() > 0) {
				print(variables.get(dimension).toString(),"开始创建insert语句...","running");
				writer.write(BR + DELIMITER + BR);
				writer.write("/**" + BR + "* 资源数据" + BR + "**/" + BR);
				writer.write(BR + DELIMITER + BR);
				writer.write(insertSql.toString());
				writer.write(BR + BR + DELIMITER + BR);
				print(variables.get(dimension).toString(),"insert语句创建完成...","running");
			}

			writer.flush();
			writer.close();
			out.close();

			if(deleteSql.length() == 0 && insertSql.length() == 0){
				print(variables.get(dimension).toString(),"该项目下数据路径字段为空，不支持导出...","start");
				return;
			}
			download(response, fileName, sqlFilePath);
			print(variables.get(dimension).toString(),"执行结束","end");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private boolean validationParameters(StudioResourceModel model, Map<String, Object> variables) {
		String text = model.getResourceParams();
		JSONArray fields = JSONObject.parseArray(text);
		for (int i = 0; i < fields.size(); i++) {
			if (!variables.containsKey(fields.getJSONObject(i).getString("name"))) {
				return false;
			}
		}
		return true;
	}

	private String buildInsertSql(StudioResourceModel resource, String dimension, Map<String, Object> variables) {
        StringBuffer sbsql = new StringBuffer();

        String json = format(resource.getResourceInsertSql(), variables);
		JSONObject dimensionData = JSONObject.parseObject(json);
		JSONObject selectAllSql = dimensionData.getJSONObject(dimension);
		if (ObjectUtils.isEmpty(selectAllSql.keySet())) {
			return "";
		}
		for (String tableName : selectAllSql.keySet()) {
			List<TableColumn> columns = null;
			List<Map<String, Object>> dataList = null;
			String selectsql = format(selectAllSql.getString(tableName), variables);
			if (SourceEnum.IDX.getSource().equals(resource.getResourceCode().toLowerCase())) {
//				String sql = sqlHelper.getNamespaceSql("com.yeejoin.amos.api.studio.face.orm.dao.StudioResourceMapper.queryForListByTableName", tableName);
//				Query query = new Query();
//				query.setSql(sql);
//				List result = IndicatorsManager.indicatorClient.queryBySql(query).getResult();
//				List<TableColumn> finalColumns = new ArrayList<>();
//				result.stream().forEach(x -> {
//					TableColumn column = JsonUtils.jsonToBean(JSON.toJSONString(x), TableColumn.class);
//					finalColumns.add(column);
//				});
//				columns = finalColumns;
//
//				query.setSql(selectsql);
//				dataList = IndicatorsManager.indicatorClient.queryBySql(query).getResult();
			} else {
				columns = this.getBaseMapper().queryForListByTableName(tableName);
				dataList = jdbcTemplate.queryForList(selectsql.toString());
			}

	        for (Map<String, Object> map : dataList) {
	            sbsql.append(INSERT_INTO);

	            sbsql.append(SPACE).append(tableName).append(SPACE);

	            sbsql.append(LEFTBRACE);
	            for (TableColumn column : columns) {
	                sbsql.append(SPLIT);
	                sbsql.append(column.getColumnName());
	                sbsql.append(SPLIT);
	                sbsql.append(COMMA);
	            }
	            sbsql.deleteCharAt(sbsql.length() - 1);
	            sbsql.append(RIGHTBRACE);
	            sbsql.append(VALUES);
	            sbsql.append(LEFTBRACE);
	            for (TableColumn column : columns) {
	                if (column.getColumnType().contains("bigint") ||
	                        column.getColumnType().contains("int") ||
	                        column.getColumnType().contains("bit(1)")) {
	                    if (!ObjectUtils.isEmpty(map.get(column.getColumnName()))) {
	                        sbsql.append(map.get(column.getColumnName()));
	                    }else {
	                        sbsql.append("0");
	                    }

	                } else {
	                    if (!ObjectUtils.isEmpty(map.get(column.getColumnName()))) {
	                        sbsql.append("'").append(map.get(column.getColumnName())).append("'");
	                    } else {
	                        sbsql.append("null");
	                    }

	                }
	                sbsql.append(COMMA);
	            }
	            sbsql.deleteCharAt(sbsql.length() - 1);
	            sbsql.append(RIGHTBRACE);
	            sbsql.append(BRANCH).append(BR);
	        }
		}

        return sbsql.toString();
	}

	public static String format(String sqlTemplate, Map<String, Object> parameter) {
		StringSubstitutor ss = new StringSubstitutor(parameter);
		String newTemplateStr = ss.replace(sqlTemplate);
		return newTemplateStr;
	}

	public void download(HttpServletResponse response, String fileName, String sqlFilePath) throws IOException {
		File f = new File(sqlFilePath);
		BufferedInputStream br = new BufferedInputStream(new FileInputStream(f));
		byte[] buf = new byte[1024];
		int len = 0;
		response.reset(); // 非常重要
		response.setContentType("application/x-msdownload");
		response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
		OutputStream out = response.getOutputStream();
		while ((len = br.read(buf)) > 0)
			out.write(buf, 0, len);
		br.close();
		out.close();
	}

	private void print(String id,String msg,String step) {
		String percent = "0";
		percent = ValidationUtil.equals(step,"end") ? "100" : ValidationUtil.equals(step,"running") ? "50" : "10";

		JSONObject event = new JSONObject();
		event.put("percent",percent);
		event.put("status", "running");
		event.put("logInfo", msg);
		event.put("time", DateUtils.toDateStr(DateUtils.format()));
		try {
			emqKeeper.getMqttClient().publish("/topicTable/solidify/" + (id.indexOf(',') != -1 ? id.split(",")[0] : id), event.toString().getBytes(), 0, false);
		} catch (MqttException e) {
			e.printStackTrace();
		}
	}

}
