package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.model.AmosToolTemplateModel;
import com.yeejoin.amos.api.tool.face.service.AmosToolTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import javax.annotation.Resource;
import java.util.List;

@RestController
@TycloudResource(module = "iot", value = "amosToolTemplate")
@RequestMapping(value = "/v1/iot/AmosToolTemplate")
@Api(tags = "丝袜哥测试")
public class AmosToolTemplateController {
    private final Logger logger = LogManager.getLogger(AmosToolTemplateController.class);

    @Resource
    private AmosToolTemplateService amosToolTemplateService;

    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @PostMapping("/save")
    @ApiOperation(value = "新增", notes = "新增")
    public ResponseModel<AmosToolTemplateModel> saveOne(@RequestBody AmosToolTemplateModel amosToolTemplateModel) {
        amosToolTemplateModel = amosToolTemplateService.createWithModel(amosToolTemplateModel);
        return ResponseHelper.buildResponse(amosToolTemplateModel);
    }

    /**
     * 根据字段查询
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @PostMapping("/select/all")
    @ApiOperation(value = "查询大全")
    public ResponseModel<List<AmosToolTemplateModel>> query(@RequestParam(value = "categoryScene") String categoryScene,
                                                            @RequestParam(value = "miniSences") String miniSences) {
        return ResponseHelper.buildResponse(amosToolTemplateService.query(categoryScene, miniSences));
    }

    /**
     * 查询所有
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @PostMapping("/every")
    @ApiOperation("查询所有")
    public ResponseModel<List<AmosToolTemplateModel>> queryEvery() {
        return ResponseHelper.buildResponse(amosToolTemplateService.queryEvery());
    }

    /**
     * 根据ID删除
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @DeleteMapping("/delete")
    @ApiOperation(value = "删除")
    public ResponseModel<Boolean> deleteById(@RequestParam(value = "templateId") Long templateId) {
        return ResponseHelper.buildResponse(amosToolTemplateService.deleteBySeq(templateId));
    }

    /**
     * 根据ID更新
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @PutMapping("/update")
    @ApiOperation(value = "更新")
    public ResponseModel<Boolean> updateById(@RequestParam(value = "templateId") Long templateId) {
        return ResponseHelper.buildResponse(amosToolTemplateService.updateTimes(templateId));
    }
}
