package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.model.TemplateCategoryModel;
import com.yeejoin.amos.api.tool.face.model.TemplateCategoryTreeModel;
import com.yeejoin.amos.api.tool.face.model.TemplateModel;
import com.yeejoin.amos.api.tool.face.service.TemplateCategoryService;
import com.yeejoin.amos.api.tool.face.service.TemplateService;
import com.yeejoin.amos.api.tool.face.service.VisualDesignerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.List;

@CrossOrigin
@RestController
@Api(tags = "模板分类管理Api")
@RequestMapping(value = "/tpl_cate")
public class TemplateCategoryResource {

    @Autowired
    private TemplateCategoryService templateCategoryService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private VisualDesignerService visualDesignerService;

    /**
     * 新增
     * @param sequenceNbr 设计器主键
     * @param templateCategoryModel 模板分类信息
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/save/{sequenceNbr}")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<TemplateCategoryModel> save(
            @PathVariable Long sequenceNbr,
            @RequestBody TemplateCategoryModel templateCategoryModel){
        templateCategoryModel.setDesignerType(visualDesignerService.queryBySeq(sequenceNbr).getDesignerType());
        templateCategoryModel = templateCategoryService.createWithModel(templateCategoryModel);
        return ResponseHelper.buildResponse(templateCategoryModel);
    }

    /**
     * 根据sequenceNbr更新
     * @param sequenceNbr 编码
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<TemplateCategoryModel> updateBySeqTplCate(@RequestBody TemplateCategoryModel templateCategoryModel, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        templateCategoryModel.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(templateCategoryService.updateWithModel(templateCategoryModel));
    }

    /**
     * 根据sequenceNbr删除
     * @param sequenceNbr 编码
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(templateCategoryService.deleteById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     * @param sequenceNbr 物理主键
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public  ResponseModel<TemplateCategoryModel> selectOne(@PathVariable Long sequenceNbr){
        return ResponseHelper.buildResponse(templateCategoryService.queryBySeq(sequenceNbr));
    }

    /**
     * 列表全部数据查询
     * @return List<ApiSourceDto>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<TemplateCategoryModel>> selectForList(){
        return ResponseHelper.buildResponse(templateCategoryService.queryForTplCateList());
    }
    /**
     * 列表树形结构查询
     * @return List<ApiSourceDto>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表树形结构查询", notes = "列表树形结构查询")
    @GetMapping(value = "/tree")
    public ResponseModel<List<TemplateCategoryTreeModel>> selectForTree(){
        return ResponseHelper.buildResponse(templateCategoryService.getTree());
    }

}
