package com.yeejoin.amos.api.tool.face.model;

import com.yeejoin.amos.api.tool.face.orm.entity.DataBaseLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

/**
 * @author r
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@ApiModel(value = "DataBaseLinkModel", description = "")
public class DataBaseLinkModel extends BaseModel {

    @ApiModelProperty(value = "主机IP")
    private String ip;

    @ApiModelProperty(value = "端口")
    private String port;

    @ApiModelProperty(value = "数据库名")
    private String dbName = "";

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "密码")
    private String passWord;

    public DataBaseLinkModel(String ip, String port, String dbName, String userName, String passWord) {
        this.ip = ip;
        this.port = port;
        this.dbName = dbName;
        this.userName = userName;
        this.passWord = passWord;
    }
    

}
