package com.yeejoin.amos.api.tool.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
// import sun.reflect.generics.tree.Tree;

import java.util.ArrayList;
import java.util.List;
//import java.util.TreeMap;

@Data
@NoArgsConstructor
@ApiModel(value = "RelationTreeModel", description = "")
public class RelationTreeModel {

    @ApiModelProperty(value = "表名称")
    private String name;

    @ApiModelProperty(value = "表字段")
    private String field;

    @ApiModelProperty(value = "前表关联字段")
    private String parentField;

    @ApiModelProperty(value = "父表名")
    private String parentName;

    @ApiModelProperty(value = "子节点")
    private List<RelationTreeModel> children = new ArrayList<>();

    public RelationTreeModel(String name, String field,String parentField ) {
        this.name = name;
        this.field = field;
        this.parentField = parentField;
    }
}
