package com.yeejoin.amos.api.tool.face.orm.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.tool.face.model.AmosToolTemplateModel;
import com.yeejoin.amos.api.tool.face.orm.entity.AmosToolTemplate;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

@Mapper
public interface AmosToolTemplateMapper extends BaseMapper<AmosToolTemplate> {
    /**
     * 全部
     */
    @Select("select TEMPLATE_NAME,AGENCY_NAME,VIEW_TIMES,TEMPLATE_LINK,REC_DATE from amos_tool_template" +
            " order by ${miniSences} ${way}")
    List<AmosToolTemplateModel> listAll(@Param("miniSences") String miniSences,
                                        @Param("way") String way);
    /**
     * 具体场景
     */
    @Select("select TEMPLATE_NAME,AGENCY_NAME,VIEW_TIMES,TEMPLATE_LINK,REC_DATE from amos_tool_template" +
            " where CATEGORY_SCENE=#{categoryScene} order by `${miniSences}` ${way}")
    List<AmosToolTemplateModel> queryByScenes(@Param("categoryScene") String categoryScene,
                                              @Param("miniSences") String miniSences, @Param("way") String way);
    /**
     * 列表展示
     */
    @Select("select TEMPLATE_ID,TEMPLATE_NAME,CATEGORY_SCENE,AGENCY_NAME,VIEW_TIMES,TEMPLATE_LINK,REC_DATE" +
            " from amos_tool_template")
    List<AmosToolTemplateModel> listData();
    /**
     * 更新查看次数
     */
    @Update("update amos_tool_template set VIEW_TIMES = VIEW_TIMES+1 where TEMPLATE_ID = #{templateId}")
    boolean updateById(Long templateId);
}
