package com.yeejoin.amos.api.tool.face.service;

import com.yeejoin.amos.api.tool.enums.SortType;
import com.yeejoin.amos.api.tool.face.model.AmosToolTemplateModel;
import com.yeejoin.amos.api.tool.face.orm.dao.AmosToolTemplateMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.AmosToolTemplate;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.annotation.Resource;
import java.util.List;

@Component
public class AmosToolTemplateService extends BaseService<AmosToolTemplateModel,
        AmosToolTemplate, AmosToolTemplateMapper> {
    @Resource
    private AmosToolTemplateMapper amosToolTemplateMapper;

    /**
     * 查询所有
     */
    public List<AmosToolTemplateModel> queryEvery() {
        return amosToolTemplateMapper.listData();
    }

    /**
     * 查看次数更新
     */
    public boolean updateTimes(Long templateId) {
        return amosToolTemplateMapper.updateById(templateId);
    }

    /**
     * 获取排序类型
     */
    private SortType getSortType(String miniSences) {
        return SortType.fromName(miniSences);
    }

    /**
     * 统一处理
     */
    public List<AmosToolTemplateModel> query(String categoryScene, String miniSences) {
        SortType sortType = getSortType(miniSences);

        if ("全部".equals(categoryScene)) {
            return amosToolTemplateMapper.listAll(sortType.getField(), sortType.getDirection());
        } else {
            return amosToolTemplateMapper.queryByScenes(categoryScene, sortType.getField(), sortType.getDirection());
        }
    }
}
