package com.yeejoin.amos.api.tool.face.service;


import com.yeejoin.amos.api.tool.face.model.ApiInfoModel;
import com.yeejoin.amos.api.tool.face.model.ApiSourceModel;
import com.yeejoin.amos.api.tool.face.orm.entity.ApiSource;
import com.yeejoin.amos.api.tool.face.orm.dao.ApiSourceMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class ApiSourceService extends BaseService<ApiSourceModel, ApiSource, ApiSourceMapper> {

    @Autowired
    private ApiInfoService apiInfoService;

    /**
     * 列表查询
     */
    public List<ApiSourceModel> queryForApiSourceList() {
        return this.queryForList("", false);
    }

    /**
     * 根据机构ID获取机构编码
     */
    public String queryCodeById(Long sequenceNbr){
        ApiSourceModel model = this.queryModelByParams(sequenceNbr);
        return  model.getCode();
    }

    /**
     * 通过API来源ID删除API来源
     */
    public Boolean deleteById(Long sequenceNbr){
        List<String> strings = apiInfoService.selectSeqByApiSource(this.queryCodeById(sequenceNbr));
        if(strings.size() != 0) {
            this.removeByIds(strings);
        }
        return this.removeById(sequenceNbr);
    }
}
