package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.DataBaseLinkModel;
import com.yeejoin.amos.api.tool.face.model.DataBaseNameListModel;
import com.yeejoin.amos.api.tool.face.orm.dao.DataBaseNameListMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.DataBaseNameList;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Service
public class DataBaseNameListService extends BaseService<DataBaseNameListModel, DataBaseNameList, DataBaseNameListMapper> {
    @Autowired
    private DataBaseLinkService dataBaseLinkService;

    /**
     * 分页查询
     */
    public Page<DataBaseNameListModel> queryForDataBasePage(Page<DataBaseNameListModel> page,Long parentId) {
        return this.queryForPage(page, null, false, parentId);
    }

    /**
     * 初始化数据库名表
     */
    public List<String> refreshDataBase(Long ipSeq) throws Exception {
        DataBaseLinkModel dataBaseLinkModel = dataBaseLinkService.queryBySeq(ipSeq);
        //清空表单
        this.remove(new QueryWrapper<DataBaseNameList>().eq("PARENT_ID", ipSeq));
        //连接数据库
        Connection connection = dataBaseLinkService.connectNewDatabase(dataBaseLinkModel);
        if (connection == null)
            return null;
        List<String> strings = new ArrayList<>();
        Collection<DataBaseNameList> dataBaseNameLists = new ArrayList<>();
        for (String name : dataBaseLinkService.getDataBaseName(connection)) {
            if (name == null)
                break;
            DataBaseNameListModel model = new DataBaseNameListModel(name, ipSeq);
            strings.add(name);
            dataBaseNameLists.add(this.prepareEntity(model));
        }
        this.saveBatch(dataBaseNameLists);
        connection.close();
        return strings;
    }
}
