package com.yeejoin.amos.api.tool.face.service;

import com.yeejoin.amos.api.tool.face.model.TemplateCategoryModel;
import com.yeejoin.amos.api.tool.face.model.TemplateCategoryTreeModel;
import com.yeejoin.amos.api.tool.face.model.TemplateModel;
import com.yeejoin.amos.api.tool.face.orm.dao.TemplateCategoryMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.TemplateCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


@Service
public class TemplateCategoryService extends BaseService<TemplateCategoryModel, TemplateCategory, TemplateCategoryMapper> {

    @Autowired
    private VisualDesignerService visualDesignerService;
    @Autowired
    private TemplateService templateService;

    /**
     * 列表查询
     */
    public List<TemplateCategoryModel> queryForTplCateList() {
        return this.queryForList("", false);
    }

    /**
     * 通过模板分类ID删除模板分类
     */
    public Boolean deleteById(Long sequenceNbr){
        List<String> strings = templateService.selectSeqsByCategorySeq(sequenceNbr);
        if(strings.size() != 0) {
            this.removeByIds(strings);
        }
        return this.removeById(sequenceNbr);
    }
    /**
     * 模板分类表单数据转化为树形节点
     */
    public List<TemplateCategoryTreeModel> tplCateToNode(List<TemplateCategoryModel> templateCategoryModels){
        List<TemplateCategoryTreeModel> nodes = new ArrayList<>();
        for (TemplateCategoryModel model : templateCategoryModels){
            TemplateCategoryTreeModel node = new TemplateCategoryTreeModel();
            node.setName(model.getCateName());
            node.setSequenceNbr(model.getSequenceNbr());
            node.setParentId(1L);
            node.setDesignerType(model.getDesignerType());
            nodes.add(node);
        }
        return nodes;
    }

    /**
     * 获得模板分类树
     */
    public List<TemplateCategoryTreeModel> getTree() {
        List<TemplateCategoryTreeModel> nodes = this.tplCateToNode(this.queryForTplCateList());
        nodes.addAll(visualDesignerService.VisualDesignerToNode(visualDesignerService.queryForVisualDesignerList()));
        return getChildren(nodes, "", 0L);
    }

    /**
     * 获得模板分类子节点（递归）
     */
    public List<TemplateCategoryTreeModel> getChildren(List<TemplateCategoryTreeModel> nodes, String parent, Long id){
        List<TemplateCategoryTreeModel> tree = new ArrayList<>();
        for (TemplateCategoryTreeModel node : nodes){
            if(node.getParentId() == 0L && parent.equals("")){
                node.setChildren(getChildren(nodes, node.getDesignerType(), node.getSequenceNbr()));
                tree.add(node);
            }
            else {
                if (parent.equals(node.getDesignerType()) && node.getParentId() != 0L) {
                    node.setParentId(id);
                    tree.add(node);
                }
            }
        }
        return  tree;
    }
}
