package com.yeejoin.amos.api.tool.face.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.PictureModel;
import com.yeejoin.amos.api.tool.face.model.TemplateCategoryTreeModel;
import com.yeejoin.amos.api.tool.face.model.TemplateModel;
import com.yeejoin.amos.api.tool.face.model.TemplateVoModel;
import com.yeejoin.amos.api.tool.face.orm.dao.TemplateMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.Template;
import com.yeejoin.amos.api.tool.utils.ConvertUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@Service
public class TemplateService extends BaseService<TemplateModel, Template, TemplateMapper> {

    @Autowired
    private TemplateCategoryService templateCategoryService;

    /**
     * 分页查询
     */
    public Page<TemplateModel> queryForTplPage(Page<TemplateModel> page, Long categorySeq, String displayName) {
        List<TemplateCategoryTreeModel> modelList = templateCategoryService.getTree();
        List<TemplateModel> records = new ArrayList<>();
        for (TemplateCategoryTreeModel visualDesigner : modelList) {
            if (Objects.equals(categorySeq, visualDesigner.getSequenceNbr())) {
                for (TemplateCategoryTreeModel category : visualDesigner.getChildren()) {
                    records.addAll(this.queryForTplListByCategorySeq(category.getSequenceNbr()));
                }
                return this.queryForPages(records, page);
            }
        }
        return this.queryForPage(page, null, false, categorySeq, displayName);
    }

    public Page<TemplateModel> queryForPages(List<TemplateModel> records, Page<TemplateModel> page) {
        Page<TemplateModel> entiryPage = new Page(page.getCurrent(), page.getSize());
        if (!ValidationUtil.isEmpty(records)) {
            page.setTotal(records.size());
            page.setPages(entiryPage.getPages());
            page.setCurrent(entiryPage.getCurrent());
            page.setSize(entiryPage.getSize());
            page.setRecords(records);
        }
        return page;
    }

    /**
     * 列表查询
     */
    public List<TemplateModel> queryForTplListByCategorySeq(Long categorySeq) {
        return this.queryForList("", false, categorySeq);
    }

    /**
     * 根据模板分类ID获取模板sequenceNb's
     */
    public List<String> selectSeqsByCategorySeq(Long categorySeq) {
        List<String> strings = new ArrayList<>();
        for (TemplateModel model : this.queryForTplListByCategorySeq(categorySeq)) {
            strings.add(Long.toString(model.getSequenceNbr()));
        }
        return strings;
    }


    /**
     * 列表查询
     */
    public List<TemplateModel> queryForTplList() {
        return this.queryForList("", false);
    }

    /**
     * 根据sequenceNbr获取模板并转化为VO
     */
    public TemplateVoModel queryForTplVo(Long sequenceNbr) {
        TemplateModel templateModel = this.queryBySeq(sequenceNbr);
        TemplateVoModel templateVoModel = this.convertVoModel(templateModel);
        if (templateModel.getContent() != null) {
            templateVoModel.setContentStr(templateModel.getContent().toString());
        }
        return templateVoModel;
    }

    /**
     * TplVoModel转化TplModel
     */
    public TemplateModel convertModel(TemplateVoModel tplVoModel) throws NoSuchFieldException, IllegalAccessException {
        TemplateModel templateModel = new TemplateModel();
        BeanUtils.copyProperties(tplVoModel, templateModel, "thumbs", "sketches", "contentStr");
        //判定thumbs为空
        if (tplVoModel.getThumbs().size() != 0) {
            templateModel.setThumb(ConvertUtil.objectListToUrl(tplVoModel.getThumbs()));
        }
        //判定sketch为空
        if (tplVoModel.getSketches().size() != 0) {
            templateModel.setSketch(ConvertUtil.objectListToUrl(tplVoModel.getSketches()));
        }
        templateModel.setContent(JSON.parseObject(tplVoModel.getContentStr()));
        return templateModel;
    }

    /**
     * 读取json文件
     */
    public String readMultipartFile(MultipartFile multipartFile) throws IOException {
        Reader reader = new InputStreamReader(multipartFile.getInputStream(), "utf-8");
        int ch = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((ch = reader.read()) != -1) {
            stringBuffer.append((char) ch);
        }
        reader.close();
        return stringBuffer.toString();
    }

    /**
     * 通过json文件建立空白模板
     */
    public TemplateModel fileToTpl(MultipartFile multipartFile) throws IOException {
        JSONObject content = JSON.parseObject(this.readMultipartFile(multipartFile));
        String str = "1668429235251548162";
        return new TemplateModel(content, Long.parseLong(str));
    }

    /**
     * model转化VO
     */
    public TemplateVoModel convertVoModel(TemplateModel templateModel) {
        TemplateVoModel tplVoModel = new TemplateVoModel();
        BeanUtils.copyProperties(templateModel, tplVoModel);
        if (templateModel.getSketch() != null)
            tplVoModel.setSketches(this.urlToPicModel(templateModel.getSketch()));
        if (templateModel.getThumb() != null)
            tplVoModel.setThumbs(this.urlToPicModel(templateModel.getThumb()));
        System.out.println(tplVoModel.getThumbs());
        return tplVoModel;
    }

    /**
     * 生成随机UID
     */
    public String getUid() {
        UUID uuid = UUID.randomUUID();
        String str = uuid.toString();
        return str.replace("-", "");
    }

    /**
     * url转化图片
     */
    public List<PictureModel> urlToPicModel(String url) {
        List<PictureModel> pictureModels = new ArrayList<>();
        PictureModel pictureModel = new PictureModel("", this.getUid(), url, "done");
        pictureModels.add(pictureModel);
        return pictureModels;
    }


}
