package com.yeejoin.amos.api.tool.face.service;


import com.yeejoin.amos.api.tool.face.model.TemplateCategoryTreeModel;
import com.yeejoin.amos.api.tool.face.model.VisualDesignerModel;
import com.yeejoin.amos.api.tool.face.orm.dao.VisualDesignerMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.VisualDesigner;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;


@Service
public class VisualDesignerService extends BaseService<VisualDesignerModel, VisualDesigner, VisualDesignerMapper> {

    /**
     * 列表查询
     */
    //    父List
    public List<VisualDesignerModel> queryForVisualDesignerList() {
        return this.queryForList("", false);
    }

    /**
     * 设计器表单数据转化为树形节点
     */
    public List<TemplateCategoryTreeModel> VisualDesignerToNode (List<VisualDesignerModel> visualDesignerModels){
        List<TemplateCategoryTreeModel> nodes = new ArrayList<>();
        for (VisualDesignerModel model : visualDesignerModels){
            TemplateCategoryTreeModel node = new TemplateCategoryTreeModel();
            node.setSequenceNbr(model.getSequenceNbr());
            node.setName(model.getDesignerName());
            node.setDesignerType(model.getDesignerType());
            nodes.add(node);
        }
        return nodes;
    }




}