package com.yeejoin.amos.api.tool.utils;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.api.tool.face.orm.entity.TableColumn;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.*;
import java.util.*;

public class DataBaseUtils {

    /**
     * 数据库备份路径
     */
    public static final String BACKUP_PATH = "/db/";

    /**
     * 数据库备份文本前缀
     */
    public static String ONESQL_PREFIX = "";
    public static String SUFFIX = "sql";
    public static String BR = "\r\n";
    public static String SLASH = "/";
    public static String BRANCH = ";";
    private static String SPLIT = "`";
    private static String SPACE = " ";
    private static String INSERT_INTO = " INSERT INTO ";
    private static String CREATE_INTO = " CREATE TABLE ";
    private static String VALUES = "VALUES";
    private static String LEFTBRACE = "(";
    private static String RIGHTBRACE = ")";
    private static String QUOTES = "'";
    private static String COMMA = ",";
    private static String DISABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 0;\r\n";
    private static String ABLEFOREIGN = "SET FOREIGN_KEY_CHECKS = 1;\r\n";
    public static String DELIMITER = "###################################";


    /**
     * 获取maps
     */
    public static List<Map<String, Object>> getMaps(String sql, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(sql);
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            while (rs.next()) {
                Map<String, Object> rowData = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; i++) {
                    rowData.put(md.getColumnName(i), rs.getObject(i));
                }
                list.add(rowData);
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            try {
                if (rs != null)
                    rs.close();
                rs = null;
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    /**
     * 获取表单列名
     */
    public static List<TableColumn> getTableColumn(String tableName, Connection connection) throws SQLException {
        String columnSql = "" +
                "\t\t SELECT\n" +
                "\t\t table_name as table_name,\n" +
                "\t\t\tcolumn_name as columnName,\n" +
                "\t\t\t( CASE WHEN ( is_nullable = 'no' && column_key != 'PRI' ) THEN '1' ELSE NULL END ) AS isRequired,\n" +
                "\t\t\t( CASE WHEN column_key = 'PRI' THEN '1' ELSE '0' END ) AS isPk,\n" +
                "\t\t\tordinal_position AS sort,\n" +
                "\t\t\tcolumn_comment as columnComment,\n" +
                "\t\t\t( CASE WHEN extra = 'auto_increment' THEN '1' ELSE '0' END ) AS isIncrement,\n" +
                "\t\t\tcolumn_type as columnType \n" +
                "\t\tFROM\n" +
                "\t\t\tinformation_schema.COLUMNS \n" +
                "\t\tWHERE\n" +
                "\t\t\ttable_schema = database()\n" +
                "\t\t\tAND table_name = \"" + tableName + "\"\n" +
                "\t\tORDER BY\n" +
                "\t\t\tordinal_position\t";
        List<Map<String, Object>> columnList = DataBaseUtils.getMaps(columnSql, connection);
        List<TableColumn> columns = new ArrayList<>();
        for (Map<String, Object> map : columnList) {
            TableColumn column = JSON.parseObject(JSON.toJSONString(map), TableColumn.class);
            if(!column.getColumnName().equals("content"))
                columns.add(column);
        }
        return columns;
    }

    /**
     * 获取insert语句
     */

    public static StringBuffer getInsertSQL(List<Map<String, Object>> dataList, List<TableColumn> columns, String tableName) {
        StringBuffer sql = new StringBuffer();
        for (Map<String, Object> map : dataList) {
            sql.append(INSERT_INTO);
            sql.append(SPACE).append(tableName).append(SPACE);
            sql.append(LEFTBRACE);
            for (TableColumn column : columns) {
                sql.append(SPLIT);
                sql.append(column.getColumnName());
                sql.append(SPLIT);
                sql.append(COMMA);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(RIGHTBRACE);
            sql.append(VALUES);
            sql.append(LEFTBRACE);
            for (TableColumn column : columns) {
                if (column.getColumnType().contains("bigint") ||
                        column.getColumnType().contains("int") ||
                        column.getColumnType().contains("bit(1)")) {
                    if (!ObjectUtils.isEmpty(map.get(column.getColumnName()))) {
                        sql.append(map.get(column.getColumnName()));
                    } else {
                        sql.append("0");
                    }
                } else {
                    if (!ObjectUtils.isEmpty(map.get(column.getColumnName()))) {
                        sql.append("'").append(map.get(column.getColumnName())).append("'");
                    } else {
                        sql.append("null");
                    }
                }
                sql.append(COMMA);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(RIGHTBRACE);
            sql.append(BRANCH).append(BR);
        }
        return sql;
    }


}
