package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.ApiInfoModel;
import com.yeejoin.amos.api.tool.face.service.ApiInfoService;
import com.yeejoin.amos.api.tool.face.service.ApiSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Arrays;
import java.util.List;

@CrossOrigin
@RestController
@Api(tags = "接口管理Api")
@RequestMapping(value = "/api-info")
public class ApiInfoResource {

    @Autowired
    private ApiInfoService apiInfoService;
    @Autowired
    private ApiSourceService apiSourceService;

    /**
     * 新增
     * @param apiInfoModel API信息
     * @return ApiInfoModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<ApiInfoModel> save(@RequestBody ApiInfoModel apiInfoModel) {
        apiInfoModel = apiInfoService.createWithModel(apiInfoModel);
        return ResponseHelper.buildResponse(apiInfoModel);
    }

    /**
     * 根据sequenceNbr更新
     * @param sequenceNbr 主键
     * @return ApiInfoModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<ApiInfoModel> updateBySequenceNbrApiInfo(@RequestBody ApiInfoModel model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(apiInfoService.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     * @param sequenceNbr 主键
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(apiInfoService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr 批量删除
     * @param sequenceNbr 主键
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/delete/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除多项", notes = "根据sequenceNbr删除多项")
    public ResponseModel<Boolean> deleteModelsBySequenceNbr(@PathVariable(value = "sequenceNbr")String sequenceNbr){
        return  ResponseHelper.buildResponse(apiInfoService.removeByIds(Arrays.asList(StringUtil.string2Array(sequenceNbr))));
    }

    /**
     * 根据sequenceNbr查询
     * @param sequenceNbr 主键
     * @return ApiInfoModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
    public ResponseModel<ApiInfoModel> selectOne(@PathVariable Long sequenceNbr) throws Exception {
        return ResponseHelper.buildResponse(apiInfoService.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     * @param current 当前页
     * @param size 每页大小
     * @param apiName API名称
     * @param sequenceNbr 主键
     * @return Page<ApiInfoModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
    public ResponseModel<Page<ApiInfoModel>> queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(value = "sequenceNbr") Long sequenceNbr,
            @RequestParam(value = "apiName",required = false)String apiName) {
        Page<ApiInfoModel> page=new Page<ApiInfoModel>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(
                apiInfoService.queryForApiInfoPage(page, apiSourceService.queryCodeById(sequenceNbr),apiName));
    }

    /**
     * 列表全部数据查询
     * @return List<ApiInfoModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ApiInfoModel>>  selectForList() {
        return ResponseHelper.buildResponse(apiInfoService.queryForApiInfoList());
    }
}
