package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.ProjectModel;
import com.yeejoin.amos.api.tool.face.service.StudioResourceService;
import com.yeejoin.amos.api.tool.utils.DatabaseUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 测试 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2023-06-06
 */

@RestController
@TycloudResource(module = "atl", value = "dataApi")
@RequestMapping(value = "/v1/dataApi")
@Api(tags = "atl-导出")
public class
DataApiResource {

    private final Logger logger = LogManager.getLogger(DataApiResource.class);

    @Autowired
    private StudioResourceService studioResourceService;

    /**
     * 依据参数导出 应用快搭增量脚本
     *
     * @throws SQLException
     */
    @TycloudOperation(ApiLevel = UserType.ANONYMOUS, needAuth = false)
    @ApiOperation(value = "导出应用快搭增量脚本")
    @RequestMapping(value = "/generateSQL", method = RequestMethod.GET)
    public void generateSQL(
            @RequestParam("resourceCode") String resourceCode,
            @RequestParam("dimension") String dimension,
            @RequestParam("ipSeq") Long ipSeq,
            HttpServletRequest request,
            HttpServletResponse response) {
        Map<String, Object> variables = new HashMap<>();
        Enumeration<String> keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            String name = (String) keys.nextElement();
            String value = request.getParameter(name);
            variables.put(name, value);
        }
        variables.remove("resourceCode");
        variables.remove("dimension");
        variables.remove("ipSeq");
        studioResourceService.generateSQL(resourceCode, dimension, ipSeq, variables, response);
    }


    /**
     * 获取项目列表
     */
    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "项目列表")
    @GetMapping("/project/list")
    public ResponseModel<List<ProjectModel>> selectByIpAgency(
            @RequestParam(value = "ipSeq") Long ipSeq,
            @RequestParam(value = "agencyCode") String agencyCode) throws SQLException {

        return ResponseHelper.buildResponse(studioResourceService.getProjectList(ipSeq, agencyCode));
    }

    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "应用列表")
    @GetMapping("application/page/project")
    public ResponseModel<Page<ProjectModel>> selectApp(
            @RequestParam(value = "ipSeq") Long sequenceNbr,
            @RequestParam(value = "projectNbr") Long projectNbr,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) throws SQLException {
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(
                DatabaseUtils.listToPage(studioResourceService.getAppList(sequenceNbr, projectNbr), current, size));
    }

    @TycloudOperation(ApiLevel = UserType.SUPER_ADMIN, needAuth = false)
    @ApiOperation(value = "数据列表")
    @GetMapping("idx/page")
    public ResponseModel<Page<ProjectModel>> selectIdx(
            @RequestParam(value = "ipSeq") Long ipSeq,
            @RequestParam(value = "agencyCode") String agencyCode,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) throws SQLException {
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(
                DatabaseUtils.listToPage(studioResourceService.getIdx(ipSeq, agencyCode), current, size));
    }
}

