package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.AgencyModel;
import com.yeejoin.amos.api.tool.face.model.DatabaseConnectionModel;
import com.yeejoin.amos.api.tool.face.service.DatabaseConnectionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;


/**
 * @author r
 */
@RestController
@Api(tags = "数据库信息")
@RequestMapping(value = "/database_link")
public class DatabaseConnectionResource {

    @Autowired
    private DatabaseConnectionService databaseConnectionService;

    /**
     * 新增
     *
     * @param dataBaseConnectionModel 数据库连接
     * @return DataBaseLinkModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<DatabaseConnectionModel> save(@RequestBody DatabaseConnectionModel dataBaseConnectionModel) throws Exception {
        return ResponseHelper.buildResponse(databaseConnectionService.save(dataBaseConnectionModel));
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param model 数据库连接
     * @return DataBaseLinkModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<DatabaseConnectionModel> updateBySeq(
            @RequestBody DatabaseConnectionModel model,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) throws Exception {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(databaseConnectionService.update(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(databaseConnectionService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     * @param sequenceNbr 主键
     * @return TemplateVoModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<DatabaseConnectionModel> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(databaseConnectionService.queryBySeq(sequenceNbr));
    }

    /**
     * 位于：脚本导出-机构管理
     * 分页查询，获取指定地址下的机构
     *
     * @param current 当前分页
     * @param size    分页大小
     * @return Page<AgencyModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "机构分页查询", notes = "分页查询")
    public ResponseModel<Page<AgencyModel>> queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam Long ipSeq) throws SQLException {
        Page<AgencyModel> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(databaseConnectionService.queryForAgencyPage(page, ipSeq));
    }

    /**
     * 位于：脚本导出-机构管理
     * 获取全部数据库ip
     * 列表全部数据查询
     *
     * @return List<DataBaseLinkModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<DatabaseConnectionModel>> selectForList() {
        return ResponseHelper.buildResponse(databaseConnectionService.queryForDataBaseList());
    }

    /**
     * 机构列表查询
     *
     * @return Page<AgencyModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/agency/list")
    @ApiOperation(httpMethod = "GET", value = "机构列表查询", notes = "列表查询")
    public ResponseModel<List<AgencyModel>> queryForList() throws SQLException, IOException {
        return ResponseHelper.buildResponse(databaseConnectionService.queryForAgencyList());
    }



}
