package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.service.LoginForwardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.ServletException;

import java.io.IOException;

/**
 * @author     Gary.Li
 * @date    2023/12/18
 */

@Controller
@TycloudResource(module = "atl", value = "dataApi")
@Api(tags = "场景案例跳转")
public class LoginForwardResource {

    @Autowired
    LoginForwardService loginForwardService;

    @RequestMapping("/forward")
    @ApiOperation(value = "获取场景大屏点击后的登录token")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ResponseBody
    public ResponseModel<String> getSceneLoginToken(){
        return ResponseHelper.buildResponse(loginForwardService.querySceneLoginToken());
    }
}
