package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.service.DatabaseConnectionService;
import com.yeejoin.amos.api.tool.face.service.RelationService;
import com.yeejoin.amos.api.tool.face.service.StudioResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;


@CrossOrigin
@RestController
@Api(tags = "机构管理Api")
@RequestMapping(value = "/agency")
public class RelationResource {
    @Autowired
    private RelationService relationService;
    @Autowired
    DatabaseConnectionService databaseConnectionService;
    @Autowired
    private StudioResourceService studioResourceService;

    /**
     * 根据机构ID和数据库sequenceNbr批量删除数据库
     *
     * @param agencyCode   机构ID
     * @param sequenceNbrs 多个主键
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/relation/{agencyCode}/{sequenceNbrs}")
    @ApiOperation(httpMethod = "DELETE", value = "机构删除", notes = "机构删除")
    public ResponseModel<String> deleteDataBase(
            @PathVariable String agencyCode,
            @PathVariable String sequenceNbrs) throws Exception {
        relationService.deleteAgency(agencyCode, sequenceNbrs);
        return ResponseHelper.buildResponse("The data has been deleted !");
    }

    /**
     * 导出SQL脚本
     *
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/export/{agencyCode}/{ipSeq}/{dbSeqs}")
    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出")
    public void generateSQL(
            @PathVariable String agencyCode,
            @PathVariable Long ipSeq,
            @PathVariable String dbSeqs,
            HttpServletResponse response,
            HttpServletRequest request) throws Exception {
        Map<String, Object> variables = new HashMap<>();
        variables.put("agencyCode", agencyCode);
        studioResourceService.generateSQLByDatabaseName("Agency","agencyCode",dbSeqs, ipSeq, variables, response);
    }


}