package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.TemplateModel;
import com.yeejoin.amos.api.tool.face.model.TemplateVoModel;
import com.yeejoin.amos.api.tool.face.service.TemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.io.IOException;
import java.util.*;

@CrossOrigin
@RestController
@Api(tags = "模板管理Api")
@RequestMapping(value = "/tpl")
public class TemplateResource {

    @Autowired
    private TemplateService templateService;

    /**
     * 新增
     * @param tplVoModel 页面表单数据
     * @return TemplateModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<TemplateModel> save(@RequestBody TemplateVoModel tplVoModel) throws Exception {
        tplVoModel.setDisplayName(tplVoModel.getComName());
        return ResponseHelper.buildResponse(templateService.createWithModel(templateService.convertModel(tplVoModel)));
    }

    /**
     * 根据sequenceNbr更新
     * @param tplVoModel 模板信息
     * @param sequenceNbr 主键
     * @return TemplateModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<TemplateModel> updateBySequenceNbrTpl(
            @RequestBody TemplateVoModel tplVoModel,
            @PathVariable(value = "sequenceNbr") Long sequenceNbr) throws NoSuchFieldException, IllegalAccessException {
        tplVoModel.setSequenceNbr(sequenceNbr);
        tplVoModel.setDisplayName(tplVoModel.getComName());
        return ResponseHelper.buildResponse(templateService.updateWithModel(templateService.convertModel(tplVoModel)));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(templateService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr删除多项
     * @param sequenceNbr 主键
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/delete/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除多项", notes = "根据sequenceNbr删除多项")
    public ResponseModel<Boolean> deleteModelsBySequenceNbr(@PathVariable(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(templateService.removeByIds(Arrays.asList(StringUtil.string2Array(sequenceNbr))));
    }

    /**
     * 根据sequenceNbr查询
     * @param sequenceNbr 主键
     * @return TemplateVoModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<TemplateVoModel> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(templateService.queryForTplVo(sequenceNbr));
    }

    /**
     * 列表分页查询
     * @param current 当前页
     * @param size    每页大小
     * @param categorySeq 模板分类ID
     * @param displayName 模板名称
     * @return Page<TemplateModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<TemplateModel>> queryForPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(value = "categorySeq") Long categorySeq,
            @RequestParam(value = "displayName", required = false) String displayName) {
        Page<TemplateModel> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(templateService.queryForTplPage(page, categorySeq, displayName));
    }

    /**
     * 列表全部数据查询
     * @return List<TemplateModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<TemplateModel>> selectForList() {
        return ResponseHelper.buildResponse(templateService.queryForTplList());
    }

    /**
     * 导入
     * @param multipartFile 文件
     * @return TemplateModel
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr导入content", notes = "根据sequenceNbr导入content")
    @PostMapping(value = "/import")
    @CrossOrigin(methods = RequestMethod.POST)
    public ResponseModel<TemplateModel> importTpl(@RequestParam("file") MultipartFile multipartFile) throws IOException {
        return ResponseHelper.buildResponse(templateService.createWithModel(templateService.fileToTpl(multipartFile)));
    }
}
