package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.ToolLibraryDetailModel;
import com.yeejoin.amos.api.tool.face.model.ToolLibraryTreeModel;
import com.yeejoin.amos.api.tool.face.service.ToolLibraryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.List;


@RestController
@TycloudResource(module = "atl", value = "dataApi")
@RequestMapping(value = "/component")
@Api(tags = "atl-组件库")
public class ToolLibraryResource {

    @Autowired
    private ToolLibraryService toolLibraryService;

    @GetMapping("/detailList")
    @ApiOperation(value = "组件库设计器节点详情")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public ResponseModel<Page<ToolLibraryDetailModel>> listComponentToolsDetails(
            @RequestParam(value = "sequenceNbr") String sequenceNbr,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size) throws SQLException, ClassNotFoundException {
        // 当前页和每页显示数量
        Page<ToolLibraryDetailModel> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(toolLibraryService.queryForComponentListDetails(page, sequenceNbr));
    }

    @GetMapping("/list")
    @ApiOperation(value = "组件库设计器节点列表")
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    public ResponseModel<List<ToolLibraryTreeModel>> listComponentTools(@RequestParam("designer") String designer) throws SQLException, ClassNotFoundException {
        return ResponseHelper.buildResponse(toolLibraryService.queryForComponentList(designer));
    }

    /**
     * 导出SQL脚本 一级功能
     * {id}表示前端传递的设计器类型
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/export/designer")
    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出")
    public void exportDesignerSQL(@RequestParam("id") String id, HttpServletResponse httpServletResponse){
        toolLibraryService.exportDesignerSQL(id,httpServletResponse);
    }

    /**
     * 导出SQL脚本 二级功能
     * @param sequenceNbr 组件在数据库表中的键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/export/component")
    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出二级组件中的所有工具的SQL")
    public void exportComponentSQL(
            @RequestParam(value = "sequenceNbr") String sequenceNbr,
            HttpServletResponse httpServletResponse)  {
        toolLibraryService.exportComponentSQL(sequenceNbr, httpServletResponse);
    }

    /**
     * 导出SQL脚本 三级功能
     * {sequenceNbrs}表示前端传递需要导出的插入sql的主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/export/tool")
    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出")
    public void exportToolSQL( @RequestParam(value = "sequenceNbrs") String sequenceNbrs, HttpServletResponse httpServletResponse){
        toolLibraryService.exportToolSQL(sequenceNbrs,httpServletResponse);
    }

}
