package com.yeejoin.amos.api.tool.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;


@EqualsAndHashCode(callSuper = true)
@Data
public class AmosToolTemplateModel extends BaseModel {

    /**
     * 模板名称
     */
    private String templateName;
    /**
     * 场景类型
     */
    private String categoryScene;
    /**
     * 效果图
     */
    @ApiModelProperty(value = "效果图")
    protected String sketch;
    /**
     * 所属机构
     */
    private String agencyName;
    /**
     * 查看次数
     */
    private Integer viewTimes;
    /**
     * 模板URL
     */
    private String templateLink;
    /**
     * 是否删除
     */
    private Boolean isDelete;

    public void setSketch(String sketch) {
        this.sketch = sketch;
    }
}
