package com.yeejoin.amos.api.tool.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
@ApiModel(value="TemplateCategoryTreeModel", description="")
public class TemplateCategoryTreeModel {
    @ApiModelProperty(value = "物理主键")
    private Long sequenceNbr;

    @ApiModelProperty(value = "父ID")
    private Long parentId = 0L;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "设计器类型")
    private String designerType = "";

    @ApiModelProperty(value = "子列表")
    private List<TemplateCategoryTreeModel> children = new ArrayList<>();

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public TemplateCategoryTreeModel(Long sequenceNb, Long parentId, String name, String designerType){
        this.sequenceNbr =sequenceNb ;
        this.parentId = parentId;
        this.name = name;
        this.designerType =designerType;
    }
    public TemplateCategoryTreeModel(Long sequenceNb, Long parentId, String name, String designerType,
                                     List<TemplateCategoryTreeModel> children){
        this.sequenceNbr =sequenceNb ;
        this.parentId = parentId;
        this.name = name;
        this.designerType =designerType;
        this.children = children;
    }

}
