package com.yeejoin.amos.api.tool.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value="ToolLibraryTreeModel", description="")
public class ToolLibraryTreeModel {

    @ApiModelProperty(value = "物理主键")
    private Long id;

    @ApiModelProperty(value = "父ID")
    private Long parentId;

    @ApiModelProperty(value = "名称")
    private String designerName;

    @ApiModelProperty(value = "设计器类型")
    private String designerType;

    @ApiModelProperty(value = "子列表")
    private List<ToolLibraryTreeModel> children = new ArrayList<>();

    public ToolLibraryTreeModel(Long id, Long parentId, String designerName, String designerType){
        this.id =id ;
        this.parentId = parentId;
        this.designerName = designerName;
        this.designerType =designerType;
    }

}
