package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.*;
import com.yeejoin.amos.api.tool.face.orm.dao.DataBaseLinkMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.DataBaseLink;
import com.yeejoin.amos.api.tool.utils.AESUtils;
import com.yeejoin.amos.api.tool.utils.DatabaseUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import javax.sql.DataSource;
import java.io.IOException;
import java.net.URL;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author r
 */

@Service
public class DatabaseConnectionService extends BaseService<DatabaseConnectionModel, DataBaseLink, DataBaseLinkMapper> {

    private static final Logger log = LogManager.getLogger(DatabaseConnectionService.class);

    @Autowired
    private DataSource dataSource;

    /**
     * 新增
     */
    public DatabaseConnectionModel save(DatabaseConnectionModel dataBaseConnectionModel) throws Exception {
        DatabaseConnectionModel model = AESUtils.encryptPwd(dataBaseConnectionModel);
        if (DatabaseUtils.isConnectionValid(model)) {
            return this.createWithModel(model);
        } else {
            return new DatabaseConnectionModel();
        }
    }

    /**
     * 编辑
     */
    public DatabaseConnectionModel update(DatabaseConnectionModel model) throws Exception {
        if (DatabaseUtils.isConnectionValid(model)) {
            return this.updateWithModel(AESUtils.encryptPwd(model));
        } else {
            return null;
        }
    }

    /**
     * 机构分页查询
     */
    public Page<AgencyModel> queryForAgencyPage(Page<AgencyModel> page, Long ipSeq) throws SQLException {
        Connection connection = DatabaseUtils.getConnection(this.queryBySeq(ipSeq));
        if (connection == null) {
            throw new SQLException("db connection is null!!!");
        }
        String selectSql = "SELECT AGENCY_NAME, AGENCY_CODE, AGENCY_DESC FROM privilege_agency;";
        List<Map<String, Object>> maps = DatabaseUtils.getMaps(selectSql, connection);
        connection.close();

        List<AgencyModel> records = new ArrayList<>();
        for (Map<String, Object> map : maps) {
            AgencyModel model = new AgencyModel();
            model.setAgencyName(map.get("AGENCY_NAME").toString());
            model.setAgencyCode(map.get("AGENCY_CODE").toString());
            if ((map.get("AGENCY_DESC") != null))
                model.setAgencyDesc(map.get("AGENCY_DESC").toString());
            records.add(model);
        }
        Page<AgencyModel> entiryPage = new Page<>(page.getCurrent(), page.getSize());
        if (!ValidationUtil.isEmpty(records)) {
            page.setTotal(records.size());
            page.setPages(entiryPage.getPages());
            page.setCurrent(entiryPage.getCurrent());
            page.setSize(entiryPage.getSize());
            page.setRecords(records);
        }
        return page;
    }

    /**
     * 机构列表查询
     */
    public List<AgencyModel> queryForAgencyList() throws SQLException, IOException {
        Connection con = dataSource.getConnection();
        URL url = new URL
                (con.getMetaData().getURL().replace("jdbc:mysql", "http"));
        con.close();
        log.info(url);
        DataBaseLink dataBaseLink = getOne(new QueryWrapper<DataBaseLink>().eq("IP", url.getHost()));
        DatabaseConnectionModel dataBaseConnectionModel = new DatabaseConnectionModel();
        Bean.toModel(dataBaseLink, dataBaseConnectionModel);

        Connection connection = DatabaseUtils.getConnection(dataBaseConnectionModel);
        if (connection == null) {
            throw new SQLException("db connection is null!!!");
        }
        String selectSql = "SELECT AGENCY_NAME, AGENCY_CODE, AGENCY_DESC FROM privilege_agency;";
        List<Map<String, Object>> maps = DatabaseUtils.getMaps(selectSql, connection);
        connection.close();

        List<AgencyModel> records = new ArrayList<>();
        for (Map<String, Object> map : maps) {
            AgencyModel model = new AgencyModel();
            model.setAgencyName(map.get("AGENCY_NAME").toString());
            model.setAgencyCode(map.get("AGENCY_CODE").toString());
            if ((map.get("AGENCY_DESC") != null))
                model.setAgencyDesc(map.get("AGENCY_DESC").toString());
            records.add(model);
        }
        return records;
    }

    /**
     * 列表查询
     */
    public List<DatabaseConnectionModel> queryForDataBaseList() {
        return this.queryForList("", false);
    }

}
