package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.DatabaseConnectionModel;
import com.yeejoin.amos.api.tool.face.model.DataBaseNameListModel;
import com.yeejoin.amos.api.tool.face.orm.dao.DataBaseNameListMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.DataBaseNameList;
import com.yeejoin.amos.api.tool.utils.DatabaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.sql.DataSource;
import java.sql.*;
import java.util.*;

@Service
public class DatabaseNameListService extends BaseService<DataBaseNameListModel, DataBaseNameList, DataBaseNameListMapper> {
    @Autowired
    private DatabaseConnectionService databaseConnectionService;

    @Autowired
    private DataBaseNameListMapper dataBaseNameListMapper;

    @Autowired
    private DataSource dataSource;

    /**
     * 分页查询
     */
    public Page<DataBaseNameListModel> queryForDataBasePage(Page<DataBaseNameListModel> page, Long parentId, int current, int size) throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.cj.jdbc.Driver");
        DatabaseConnectionModel dataBaseConnectionModel = databaseConnectionService.queryBySeq(parentId);
        Connection connection = dataSource.getConnection();
        Statement statement = connection.createStatement();
        String sql = "show databases";
        ResultSet rs = statement.executeQuery(sql);
        List<DataBaseNameListModel> list = new ArrayList<>();
        long result = 1;
        try {
            while (rs.next()) {
                DataBaseNameListModel listModel = new DataBaseNameListModel();
                listModel.setDbName(rs.getString("Database"));
                listModel.setParentId(parentId);
                listModel.setSequenceNbr(result);
                list.add(listModel);
                result++;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            try {
                if (rs != null)
                    rs.close();
                rs = null;
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        connection.close();
//        List<DataBaseNameList> dataBaseNameLists = dataBaseNameListMapper.queryList();
//        for (DataBaseNameList dataBaseNameList:dataBaseNameLists){
//            for (DataBaseNameListModel dataBaseNameListModel:list){
//                if (dataBaseNameList.getDbName().equals(dataBaseNameListModel.getDbName())){
//                    dataBaseLinkModel.setSequenceNbr(dataBaseNameList.getSequenceNbr());
//                }
//            }
//        }
        int count = list.size();
        page.setSize(size);
        page.setCurrent(current);
        page.setTotal(count);
        // 计算分页总页数
        page.setPages(count % 10 == 0 ? count / 10 : count / 10 + 1);
        int startIndex = (current - 1) * size;
        page.setRecords(list.subList(startIndex, Math.min(startIndex + size, list.size())));
        return page;
    }

    /**
     * 初始化数据库名表
     */
    public List<String> refreshDatabase(Long ipSeq) throws Exception {
        DatabaseConnectionModel databaseConnectionModel = databaseConnectionService.queryBySeq(ipSeq);
        // 清空表单
        this.remove(new QueryWrapper<DataBaseNameList>().eq("PARENT_ID", ipSeq));
        // 连接数据库
        Connection connection = DatabaseUtils.getConnection(databaseConnectionModel);
        if (connection == null)
            return null;
        List<String> strings = new ArrayList<>();
        Collection<DataBaseNameList> dataBaseNameLists = new ArrayList<>();
        for (String dbName : DatabaseUtils.getDatabaseNames(connection)) {
            DataBaseNameListModel model = new DataBaseNameListModel(dbName, ipSeq);
            strings.add(dbName);
            dataBaseNameLists.add(this.prepareEntity(model));
        }
        this.saveBatch(dataBaseNameLists);
        connection.close();
        return strings;
    }
}
