const { commonExternals } = require('amos-build/lib/tools/pluginConfig');

const umdConfig = commonExternals([
  'react',
  'react-dom',
  'amos-react-router',
  'prop-types',
  'amos-antd',
  'amos-framework',
  'xgplayer',
  'xgplayer-flv',
  'xgplayer-hls',
  'xgplayer-hls.js',
  'xgplayer-flv.js',
  'amos-designer',

  // studio asp remote 需要
  'base-r3d',
  'amos-gojs'
]);

module.exports = {
  // dir 和 list 用于从 pkg 中拷贝 mf 包
  dir: 'website/umd_lib',
  list: [
    ...umdConfig.list,

    // codemirror、ace
    { pkg: 'amos-code-actuator', umd: 'dist' },
    // tinymce quill
    { pkg: 'amos-richtext', umd: 'umd' },
    // echarts all
    { pkg: 'amos-viz', umd: 'umd' }
  ],

  externals: {
    ...umdConfig.externals,

    'amos-code-actuator/lib/codemirror/umd': 'ActuatorCM',
    // ace editor
    'amos-code-actuator/lib/ace/umd': 'ActuatorACE',
    'amos-viz/lib/echarts/umd': 'VizEcharts',
    // rich text
    'amos-richtext/lib/quill/umd': 'RichTextQuill',
    'amos-richtext/lib/tinymce/umd': 'RichTextMCE'
  },

  scripts: {
    // 注意，数组中，靠前的后加载
    head: [...umdConfig.scripts.head],
    body: [
      ...umdConfig.scripts.body,

      'amos-code-actuator/codemirror.umd.js',
      'amos-code-actuator/ace.umd.js',
      'amos-viz/viz-echarts.umd.js',
      'amos-richtext/tinymce.umd.js',
      'amos-richtext/quill.umd.js'
    ]
  },
  // link 样式可以, 均放在 head
  links: [...umdConfig.links]
};
