// 该模块存放系统通用 api 接口
// 各自模块的 api 存放在自己模块根目录下
import * as endConf from 'amos-processor/lib/config/endconf';

import { request, gateWay } from '@gm/graphmod-utils';

const completePrefix = endConf.completePrefix;
const AmosConfig = endConf.AmosConfig;
const baseURI = AmosConfig.httpURI.baseURI;

const {
  commonGet,
  commonPost,
  commonPut,
  formatUrl,
  commonDelete,
  formatObjUrl,
  fileDownload
} = request;


export const UrlConsts = {
  deleteAgency: (url) => completePrefix(baseURI, 'atl/agency/relation/{agencyCode}/{sequenceNbrs}'),
  // exportAgency: (url) => completePrefix(baseURI, 'atl/agency/export/{agencyCode}/{sequenceNbrs}'),
  exportAgency: (url) => completePrefix(baseURI, 'atl/agency/export/{agencyCode}/{ipSeq}/{sequenceNbrs}'),
  generateSqlUrl: url => completePrefix(baseURI, 'atl/v1/dataApi/generateSQL') // 通用导出SQL脚本 get
};

/**
 * 删除机构
 */
export const deleteByAgencyCode = (agencyCode, sequenceNbrs) => {
  return commonDelete(formatUrl(UrlConsts.deleteAgency(), { agencyCode, sequenceNbrs }));
};

/**
 * 通用应用、数据SQL脚本
 */
export const templateDownload = (params) => {
  return fileDownload({ url: formatObjUrl({ url: UrlConsts.generateSqlUrl(), filter: params }) });
};

/**
 * 导出机构
 */
export const exportByAgencyCode = (agencyCode, ipSeq, sequenceNbrs) => {
  return fileDownload({ url: formatUrl(UrlConsts.exportAgency(), { agencyCode, ipSeq, sequenceNbrs }) });
};
