import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { BarGroup, IconButton, briskWarningTip } from 'amos-designer';
import { Icon, Switch } from 'amos-framework';
import { templateDownload, deleteByAgencyCode, exportByAgencyCode } from '../api';
import { connectGlobalPage } from '@gm/graphmod-common';
import ExecuteProgress from './ExecuteProgress';
import { LocationParam } from 'amos-tool';

/**
 * 导出sql脚本模块
 * @class DownloadView
 * @extends {Component}
 */
@connectGlobalPage({
  testDataConfig: {
    // resourceCode: 'StudioApplication', // 标识
    // dimension: 'appSeq', // 字段
    // appSeq: '1688479372626911235',
    // mqttUrl: 'ws://172.16.3.18:8088/mqtt',
    // type: 'exportAgency',
    // position: 'header'
  }
})
class DownloadView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      downloadVisible: false,
      logsVisible: false,
      selectId: ''
    };
  }

  handleClose = (key) => {
    this.setState({
      [key]: false
    });
  };

  handleOpen = (key) => {
    this.setState({
      [key]: true
    });
  };

  handleItemClick = () => {
    const { selectedRowKeys = [], dataConfig, record } = this.props;
    let ipSeq = null;
    let agencyCode = null;
    let sequenceNbrs = null;
    switch (dataConfig.type) {
      case 'deleteAgency':
        agencyCode = LocationParam.getLocationParamByName('agencyCode');
        break;
      case 'exportAgency':
        agencyCode = LocationParam.getLocationParamByName('agencyCode');
        ipSeq = LocationParam.getLocationParamByName('ipSeq');
        break;
      case 'export':
        ipSeq = LocationParam.getLocationParamByName('ipSeq');
        break;
    }

    if (selectedRowKeys.length > 0 || record) {
      this.setState({ selectId: selectedRowKeys.length === 0 ? record.id ?? record.sequenceNbr : selectedRowKeys[0], logsVisible: true }, () => {
        if (dataConfig.dimension && (selectedRowKeys.length > 0 || record)) {
          dataConfig[dataConfig.dimension] = (record ? record.id ?? record.sequenceNbr : null) || selectedRowKeys.join(',');
          switch (dataConfig.type) {
            case 'deleteAgency': {
               sequenceNbrs = dataConfig[dataConfig.dimension];
              deleteByAgencyCode(agencyCode, sequenceNbrs);
            }
              break;
            case 'exportAgency': {
               sequenceNbrs = dataConfig[dataConfig.dimension];
              // exportByAgencyCode(agencyCode, sequenceNbrs);
              exportByAgencyCode(agencyCode, ipSeq, sequenceNbrs);
            }
              break;
            case 'export':
              templateDownload({ resourceCode: dataConfig.resourceCode, dimension: dataConfig.dimension, [dataConfig.dimension]: dataConfig[dataConfig.dimension], ipSeq });
              break;
          }

        }
      });
    } else {
      briskWarningTip('至少选择一行数据');
    }
  };

  render() {
    const { dataConfig = {}, record } = this.props;
    const { logsVisible, selectId } = this.state;

    switch (dataConfig.type) {
      case 'deleteAgency':
        return (
          <div>
            {dataConfig.position === 'header' ?
              <div className="ig-stage-toolbar-right">
                <BarGroup label="删除" mode="none" position="right">
                  <IconButton colorful icon="delete" title="删除" style={{ borderRadius: 4 }} onClick={() => this.handleItemClick()} />
                </BarGroup>
              </div>
              :
              <p onClick={this.handleItemClick}><Icon icon="download" />删除</p>}
            <ExecuteProgress visible={logsVisible} mqttUrl={dataConfig.mqttUrl} exeId={selectId} onClose={() => this.handleClose('logsVisible')} />
          </div>
        );
      case 'exportAgency':
        return (
          <div>
            {dataConfig.position === 'header' ?
              <div className="ig-stage-toolbar-right">
                <BarGroup label="导出脚本" mode="none" position="right">
                  <IconButton colorful icon="export" title="导出SQL脚本" style={{ borderRadius: 4 }} onClick={() => this.handleItemClick()} />
                </BarGroup>
              </div>
              :
              <p onClick={this.handleItemClick}><Icon icon="download" />下载</p>}
            <ExecuteProgress visible={logsVisible} mqttUrl={dataConfig.mqttUrl} exeId={selectId} onClose={() => this.handleClose('logsVisible')} />
          </div>
        );
      case 'export':
        return (
          <div>
            {dataConfig.position === 'header' ?
              <div className="ig-stage-toolbar-right">
                <BarGroup label="导出脚本" mode="none" position="right">
                  <IconButton colorful icon="export" title="导出SQL脚本" style={{ borderRadius: 4 }} onClick={() => this.handleItemClick()} />
                </BarGroup>
              </div>
              :
              <p onClick={this.handleItemClick}><Icon icon="download" />下载</p>}
            <ExecuteProgress visible={logsVisible} mqttUrl={dataConfig.mqttUrl} exeId={selectId} onClose={() => this.handleClose('logsVisible')} />
          </div>
        );
    }

  }
}

DownloadView.propTypes = {
  selectedRowKeys: PropTypes.array,
  dataConfig: PropTypes.object,
  record: PropTypes.object
};

export default DownloadView;
