import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs, TagSelect, StdFormRow, CardPane, Row, Col } from 'amos-framework';
import { getSortSences } from './api';
import { commonGet } from '@gm/graphmod-utils/src/request';

import './index.scss';

const { TabList, Tab, TabPanel } = Tabs;
const categoryScene = ['全部', '新能源', '水利环境', '医疗健康', '智慧城市', '智慧园区', '企业运营', '物流仓库', '生产制造', '其他'];
const miniSences = ['综合排序', '热门推荐', '最新发布'];

function ListCards({ cardItems }) {
  const rows = [];
  // console.log("传入ListCards中的carditems:")
  // console.log(cardItems)
  function handleClick() {
    // window.open(this);

    // 向后端先发送
    const backendUrl = "http://172.16.0.120:30002/atl/forward?url=" + encodeURIComponent(this);
    commonGet(backendUrl).then(data => {
      console.log('Data:', data);
      window.open(this + "&token=" + data);
    });
  }

  for (let i = 0; i < cardItems.length; i += 4) {
    const rowItems = cardItems.slice(i, i + 4);

    const cols = rowItems.map((cardItems, index) => (
      <Col span={6} key={index}>
        <div style={{ margin: 15, display: 'flex', justifyContent: 'center' }}>
          <button style={{ width: '100%', height: '100%', border: 0, padding: 0 }} onClick={handleClick.bind(cardItems.templateLink)}>
            <CardPane style={{ width: '100%', height: 270, border: 0 }} bodyStyle={{ height: 270, padding: 0 }}>
              <div style={{ height: '75%' }}>
                <img alt="example" width="100%" height="100%" style={{ objectFit: 'cover', borderRadius: 10 }} src={cardItems.sketch} />
              </div>
              <div style={{ padding: '10px 0px 10px 80px' }}>
                <h2 style={{ textAlign: 'left', margin: 0 }}>{cardItems.templateName}</h2>
                <div style={{ display: 'flex' }}>
                  <p style={{ textAlign: 'left', marginTop: '5px', fontSize: '16px' }}>
                    {cardItems.agencyName} | 热度指数:{cardItems.viewTimes}
                  </p>
                </div>
              </div>
            </CardPane>
          </button>
        </div>
      </Col>
    ));

    rows.push(
      <Row gutter={16} key={((i + 1) / 4) | 0}>
        {cols}
      </Row>
    );
  }
  return <div>{rows}</div>;
}

class Scene extends Component {
  static propTypes = {
    routeState: PropTypes.object,
    onBack: PropTypes.func
  };

  static contextTypes = {
    browserHistory: PropTypes.object
  };

  static defaultProps = {
    routeState: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      mode: 'divider',
      cardItems: [],
      selectScene: categoryScene[0],
      selectMiniSence: miniSences[0]
      // mode2: 'line',
      // mode3: 'bullet'
    };
  }

  componentDidMount() {
    this.getSenceLists();
  }

  handleBack = () => {
    if (this.props.onBack) {
      this.props.onBack();
    } else {
      this.context.browserHistory.goBack();
    }
  };
  handleChange = value => {
    this.setState({
      mode: value
    });
  };
  getSenceLists = () => {
    getSortSences(this.state.selectScene, this.state.selectMiniSence).then(response => {
      this.setState({
        cardItems: response
      });
      // console.log(this.state.cardItems);
    });
  };
  handleSenecesSubmit = value => {
    if (value !== '') {
      this.setState(
        {
          selectScene: value
        },
        () => {
          this.getSenceLists();
        }
      );
    }
  };
  handleMiniSenecesSubmit = value => {
    if (value !== '') {
      this.setState(
        {
          selectMiniSence: value
        },
        () => {
          this.getSenceLists();
        }
      );
    }
  };

  render() {
    const { mode } = this.state;
    return (
      <div>
        <Tabs mode={mode}>
          <TabList style={{ padding: 10 }}>
            <span>&nbsp;&nbsp;</span>
            <Tab>&nbsp;&nbsp;应用模板&nbsp;&nbsp;</Tab>
          </TabList>
          <TabPanel style={{ padding: 0 }}>
            <StdFormRow label="场景" block id="scene" style={{ padding: '10px 0px 10px 20px', marginBottom: 0 }}>
              <TagSelect defaultValue={categoryScene[0]} data={categoryScene} onChange={this.handleSenecesSubmit} expandable single />
            </StdFormRow>
            <StdFormRow block style={{ padding: '10px 0px 10px 20px', marginBottom: 0 }}>
              <TagSelect defaultValue={miniSences[0]} data={miniSences} onChange={this.handleMiniSenecesSubmit} expandable single />
            </StdFormRow>
            <div style={{ overflowY: 'auto', height: '800px' }}>
              <ListCards cardItems={this.state.cardItems} />
            </div>
          </TabPanel>
        </Tabs>
      </div>
    );
  }
}

export default Scene;
