import { request, gateWay } from '@gm/graphmod-utils';

const {
  commonGet,
  commonPost,
  commonPut,
  formatUrl,
  completePrefix,
  commonDelete,
  formatObjUrl,
  fileDownload,
  buildPageable,
} = request;

export const UrlConsts = {
  getSortSencesUrl: () => completePrefix()(gateWay.atl, 'scene/select/all')
};

export const getSortSences = (categoryScene, miniSences) => {
  const formData = new window.FormData();
  formData.append('categoryScene', categoryScene);
  formData.append('miniSences', miniSences);
  return commonPost(UrlConsts.getSortSencesUrl(), formData );
};

