import React, { Component } from 'react';
import * as endConf from 'amos-processor/lib/config/endconf';
import PropTypes from 'prop-types';
import { browserHistory } from 'amos-react-router';
import getSketchCompnents from './sketch';

const AmosConfig = endConf.AmosConfig;
const bizURI = AmosConfig.httpURI.bizURI;
const headers = AmosConfig.headers;
console.log('------------------>', bizURI);

/**
 * SimulationPage
 *
 * @class SimulationPage
 * @extends {Component}
 */
class SimulationPage extends Component {

  static propTypes = {
    location: PropTypes.object,
    dataConfig: PropTypes.object,
    visualParams: PropTypes.object,
    data: PropTypes.string
  };

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    let { data, location, dataConfig = {}, visualParams = {}, ...other } = this.props;

    if (window.__gm_test_token){
      headers.token = window.__gm_test_token;
    }

    // debugger
    const Com = getSketchCompnents(data);
    const appConfig = {
      browserHistory,
      ...headers
    };
    dataConfig = {
      URI: {
        bizURI
      },
      ...dataConfig
    };
    visualParams = {
      width: '100%',
      height: '100%',
      ...visualParams
    };

    return (
      <Com {...other} appConfig={appConfig} visualParams={visualParams} dataConfig={dataConfig} routeState={location.state} />
    );
  }
}

export default SimulationPage;
