import React, { Component } from 'react';
import PropTypes from 'prop-types';
import InfoList from './InfoList';
/**
 * 更多分页的信息列表
 *
 * @class MoreInfoList
 * @extends {Component}
 */
class MoreInfoList extends Component {
  static Item = InfoList.Item;

  static propTypes = {
    onReload: PropTypes.func,
    total: PropTypes.number,
    current: PropTypes.number,
    dataSource: PropTypes.array
  };

  static defaultProps = {
    dataSource: []
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    const { onReload, dataSource, current, total, ...rest } = this.props;
    return (
      <div className="ccs-com-moreinfolist">
        <InfoList dataSource={dataSource} {...rest} />
        {
          dataSource.length < total &&
            <div className="ccs-com-moreinfolist-more" onClick={() => onReload(current + 1)}>加载更多</div>
        }
      </div>
    );
  }
}

export default MoreInfoList;
