import React, { Component } from 'react';
// import PropTypes from 'prop-types';
import VideoInfo from './../video';
import DynamicInfo from './../dynamicInfo';
import TabsMenus from './TabsMenus';


const baseImgUrl = 'upload/sfcc/common/image/';

const menus = [
  { key: '动态信息', name: '动态信息', img: `${baseImgUrl}动态信息.png`, isModel: false, component: DynamicInfo },
  { key: '现场视频', name: '现场视频', img: `${baseImgUrl}营区视频.png`, isModel: false, component: VideoInfo }
];
/**
 * 灾情信息-右侧区域
 *
 * @class DisasterLeft
 * @extends {Component}
 */
class DisasterLeft extends Component {
  constructor(props) {
    super(props);
    this.state = {
      active: menus[0].key,
      activeModal: undefined
    };
  }

  componentDidMount() {
    this.onClick(menus[0]);
  }

  onClick = (data) => {
    if (data.isModel) {
      this.setState({ activeModal: data.key }, () => {
        data.isModel && this.node.open && this.node.open();
      });
    } else {
      this.setState({ active: data.key });
    }
  }

  handleCancel = () => {
    this.setState({ activeModal: undefined });
  }

  render() {
    const { active, activeModal } = this.state;
    const data = menus.find(e => e.key === active) || {};
    const modalData = menus.find(e => e.key === activeModal) || {};
    const Com = data.component || DynamicInfo;
    const ModalCom = modalData.component || null;
    return (
      <div className="ccs-disaster-left">
        <div className="ccs-disaster-tabpanel">
          <Com {...this.props} />
          {ModalCom && <ModalCom ref={node => this.node = node} visible onCancel={this.handleCancel} {...this.props} />}
        </div>
        <TabsMenus list={menus} onClick={this.onClick} />
      </div>
    );
  }
}

export default DisasterLeft;
