import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { CardPane, OverFlowText } from 'amos-designer';
import { FormInfo } from 'amos-framework';


const fields = [
  { key: 'alarmType', label: '警情类型' },
  { key: 'alertSource', label: '警情来源' },
  { key: 'contactUser', label: '联系人' },
  { key: 'contactPhone', label: '联系电话' },
  { key: 'unitInvolved', label: '事发单位' },
  { key: 'trappedNum', label: '被困人数' },
  { key: 'casualtiesNum', label: '伤亡人数' },
  { key: 'address', label: '地址' }
];

class AlarmDetails extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  componentDidMount() {
    // const { record } = this.props;
    // alarmDetailAction(record.sequenceNbr).then(d => {
    //   this.setState({
    //     info: d
    //   });
    // });
  }

  renderCommon(){
    const { info  } = this.props;
    return (
      <div className="jcs-alarm-detail-common">
        <FormInfo labelWidth="7em" column={2} fields={fields} datas={info.alertCalledFormDto.alertCalled} />
      </div>
    );
  }

  // renderContent(){
  //   const { info = {} } = this.state;
  //   return (
  //     <div className="jcs-alarm-detail">
  //       {this.renderCommon()}
  //       <div className="jcs-alarm-detail-dynamic">
  //         <FormInfo labelWidth="7em" column={2} fields={info.dynamicFormAlert} />
  //       </div>
  //       <div className="jcs-alarm-detail-footer">
  //       </div>
  //     </div>
  //   );
  // }

  render() {
    const { info } = this.props;
    if (info) {
      return (
        <div>
          <div className="jcs-alarm-detail">
            {this.renderCommon() }
            {<div className="jcs-alarm-detail-dynamic">
              <FormInfo labelWidth="7em" column={2} fields={info.alertCalledFormDto.dynamicFormAlert} />
            </div>}
          </div>
        </div>
      );
    } else {
      return (
        <div>
            111
        </div>
      );
    }

  }
}

AlarmDetails.propTypes = {
  onCancel: PropTypes.func,
  visible: PropTypes.bool,
  record: PropTypes.object,
  info: PropTypes.object
};

export default AlarmDetails;
