import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { LabelValue } from 'amos-designer';
import { deepCopy } from 'amos-tool';
import { ScreenCard } from './../../common';
import { stationInfo } from './../config';
/**
 * 警情详情
 *
 * @class DisasterDetails
 * @extends {Component}
 */
class DisasterDetails extends Component {

  static propTypes = {
    alarm: PropTypes.object
  };

  static defaultProps = {
    alarm: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      infoList: [],
      info: {}
    };
  }

  componentDidMount() {
    this.requestData();
  }

  requestData = () => {
    const { alarm } = this.props;
    const data = deepCopy(stationInfo);
    data.forEach(item => {
      item.value = alarm[item.key] ? alarm[item.key] : '';
    });
    this.setState({
      infoList: data,
      info: alarm
    });
  }

  render() {
    const { infoList, info } = this.state;
    return (
      <ScreenCard title={info.stationName} wrapperClassName="details" className="ccs-disaster-dynamicinfo-details">
        {
          (infoList || []).map(e => (
            <LabelValue className="ccs-labelvalue" key={e.key} width="100%" labelWidth="7.8em" label={e.label} value={e.value} />
          ))
        }
      </ScreenCard>
    );
  }
}

export default DisasterDetails;
