import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { VideoMatrix } from '@gm/graphmod-common';
import { videoPageListAction } from './../api';
/**
 * 视频信息
 *
 * @class VideoInfo
 * @extends {Component}
 */
class VideoInfo extends Component {

  static propTypes = {
    alarm: PropTypes.object
  };

  constructor(props) {
    super(props);
    this.state = {
      page: 1,
      size: 4,
      total: 0,
      videos: []
    };
  }

  componentDidMount() {
    this.onRequestVedios();
  }

  onRequestVedios = () => {
    const { alarm } = this.props;
    const { page, size } = this.state;
    videoPageListAction(page, size, alarm.fireEquipmentMrid || '').then(resp => {
      const { records, total } = resp;
      const date =  records.map((item) => {
        let json = { ...item };
        json.key = item.id;
        json.vedioId = item.mrid;
        json.token = item.token || '';
        json.url = item.playUrl;
        json.code = item.mrid;
        return json;
      });
      this.setState({ videos: date, total: Number(total) });
    });
  }

  handlePageChange = (page, size) => {
    this.setState({ videos: [], page, size }, this.onRequestVedios);
  }

  render() {
    const { page, size, videos, total } = this.state;
    return (
      <div className="ccs-disaster-dynamicinfo">
        <div className="ccs-disaster-dynamicinfo-video-wrapper">
          <div className="ccs-disaster-video-header">
            <VideoMatrix.Pagination page={page} size={size} onPageChange={this.handlePageChange} total={total} />
          </div>
          <div className="ccs-disaster-video-content">
            <VideoMatrix
              videos={videos}
              matrix={size}
              title={(e) => `${e.name || ''}-${e.position || ''}`}
              dataConfig={{ videoMore: false }}
            />
          </div>
        </div>
      </div>
    );
  }
}

export default VideoInfo;
