import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { ScreenCard } from './../../common';
import VideoItem from './VideoItem';
import { videoAction } from './../../api';
/**
 * 监控
 *
 * @class VideoDetails
 * @extends {Component}
 */
class VideoDetails extends Component {

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {
      total: 0, // 总数
      current: 1, // 当前页
      pageSize: 4, // 页码大小
      videoList: [
        // { key: 'vedio1', title: '',  vedioId: 'vedio1', token: '', liveVideoHost: '' },
        // { key: 'vedio2', title: '',  vedioId: 'vedio2', token: '', liveVideoHost: '' },
        // { key: 'vedio3', title: '',  vedioId: 'vedio3', token: '', liveVideoHost: '' },
        // { key: 'vedio4', title: '',  vedioId: 'vedio4', token: '', liveVideoHost: '' }
      ]
    };
  }
  componentDidMount() {
    const { current, pageSize } = this.state;
    videoAction( current,pageSize ).then(resp => {
      const {  records } = resp;
      const date =  records.map((item) => {
        let json = {};
        json.key = item.id;
        json.vedioId = item.code;
        json.token = item.token;
        json.liveVideoHost = item.url;
        return json;
      });
      this.setState({ videoList: date });
    });
  }

  render() {
    const { videoList } = this.state;
    return (
      <ScreenCard wrapperClassName="ccs-wh" title="机场视频" className="ccs-disaster-videos" >
        {
          videoList.map(e => (
            <VideoItem key={e.key} {...e}  />
          ))
        }
      </ScreenCard>
    );
  }
}

export default VideoDetails;
