import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connectGlobalPage } from '@gm/graphmod-common';
import { MQTTProvider } from 'amos-mqtt';
import AlarmTypeScale from './side/AlarmTypeScale';
import IotEquipment from './side/IotEquipment';
import FaultyEquipment from './side/FaultyEquipment';
import AlarmDynamic from './side/AlarmDynamic';
import AccessSummary from './side/AccessSummary';
import OnDutyDynamicMap from './map';
import './index.scss';

/**
 * 物联监控
 *
 * @class Content
 * @extends {Component}
 */
@connectGlobalPage({
  testDataConfig: {
    mqttUrl: 'ws://172.16.10.85:8083/mqtt', // 消息地址
  },
  testVisualParams: {
    theme: ''
  }
})
class Content extends Component {
  static propTypes = {
    dataConfig: PropTypes.object
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { dataConfig = {} } = this.props;
    return (
      <MQTTProvider url={dataConfig.mqttUrl}>
        <div className="ccs-iot-monitoring on-iot-monitoring">
          <div className="ccs-iot-monitoring-side">
            <div className="ccs-iot-monitoring-left">
              <AccessSummary />
              <IotEquipment />
              <FaultyEquipment />
            </div>
          </div>
          <div className="ccs-iot-monitoring-content">
            <OnDutyDynamicMap />
          </div>
          <div className="ccs-iot-monitoring-side">
            <div className="ccs-iot-monitoring-right">
              <AlarmTypeScale />
              <AlarmDynamic />
            </div>
          </div>
        </div>
      </MQTTProvider>
    );
  }
}

export default Content;
